/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.transposer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.belts.BeltAttachableLogisticalBlock;
import com.simibubi.create.content.logistics.block.transposer.TransposerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TransposerBlock
extends BeltAttachableLogisticalBlock {
    public static BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public TransposerBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.TRANSPOSER.create();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{POWERED}));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.TRANSPOSER.get(TransposerBlock.getBlockFacing(state));
    }

    @Override
    protected boolean isVertical() {
        return false;
    }

    @Override
    protected BlockState getVerticalDefaultState() {
        return AllBlocks.VERTICAL_TRANSPOSER.getDefaultState();
    }

    @Override
    protected BlockState getHorizontalDefaultState() {
        return AllBlocks.TRANSPOSER.getDefaultState();
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Direction blockFacing = TransposerBlock.getBlockFacing(state);
        BlockState newState = state;
        newState = blockFacing.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)blockFacing.func_176734_d()) : (BlockState)state.func_177231_a((IProperty)UPWARD);
        BlockPos pos = context.func_195995_a();
        world.func_175656_a(pos, newState);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TransposerTileEntity) {
            TransposerTileEntity transposer = (TransposerTileEntity)te;
            CompoundNBT compound = new CompoundNBT();
            transposer.func_189515_b(compound);
            world.func_175713_t(pos);
            world.func_175690_a(pos, TileEntity.func_203403_c((CompoundNBT)compound));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState stateForPlacement = super.func_196258_a(context);
        return (BlockState)stateForPlacement.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        Direction blockFacing = TransposerBlock.getBlockFacing(state);
        if ((fromPos.equals((Object)pos.func_177972_a(blockFacing)) || fromPos.equals((Object)pos.func_177972_a(blockFacing.func_176734_d()))) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return;
        }
        if (!this.reactsToRedstone()) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    protected boolean reactsToRedstone() {
        return true;
    }

    public static class Vertical
    extends TransposerBlock {
        public Vertical(Block.Properties properties) {
            super(properties);
        }

        @Override
        protected boolean isVertical() {
            return true;
        }
    }
}

