/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;

public class BeltTunnelRenderer
extends SafeTileEntityRenderer<BeltTunnelTileEntity> {
    public BeltTunnelRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(BeltTunnelTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        SuperByteBuffer flapBuffer = AllBlockPartials.BELT_TUNNEL_FLAP.renderOn(te.func_195044_w());
        SuperByteBuffer indicatorBuffer = AllBlockPartials.BELT_TUNNEL_INDICATOR.renderOn(te.func_195044_w());
        BlockPos pos = te.func_174877_v();
        World world = te.func_145831_w();
        for (Direction direction : Direction.values()) {
            if (!te.flaps.containsKey(direction)) continue;
            float horizontalAngle = direction.func_185119_l() + 90.0f;
            if (direction.func_176740_k() != Direction.Axis.X) {
                horizontalAngle += 180.0f;
            }
            float flapPivotX = -0.9375f;
            float flapPivotY = -0.5f;
            float flapPivotZ = 0.0f;
            for (int segment = 0; segment <= 3; ++segment) {
                float f = te.flaps.get(direction).get(partialTicks);
                if (direction.func_176740_k() == Direction.Axis.X) {
                    f *= -1.0f;
                }
                float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
                float abs = Math.abs(f);
                float flapAngle = MathHelper.func_76126_a((float)((float)((double)(1.0f - abs) * Math.PI * (double)intensity))) * 30.0f * -f;
                flapAngle = (float)((double)(flapAngle / 180.0f) * Math.PI);
                IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
                if (te.syncedFlaps.containsKey(direction)) {
                    float lightIntensity = abs * abs * abs;
                    int indicatorLight = WorldRenderer.func_228421_a_((ILightReader)world, (BlockPos)pos);
                    int indicatorBlockLight = LightTexture.func_228450_a_((int)indicatorLight);
                    int indicatorSkyLight = LightTexture.func_228454_b_((int)indicatorLight);
                    indicatorBlockLight = Math.max(indicatorBlockLight, (int)(12.0f * lightIntensity));
                    indicatorLight = LightTexture.func_228451_a_((int)indicatorBlockLight, (int)indicatorSkyLight);
                    int color = ColorHelper.mixColors(0x808080, 0xFFFFFF, lightIntensity);
                    indicatorBuffer.rotateCentered(Direction.UP, (float)((double)((horizontalAngle + 90.0f) / 180.0f) * Math.PI)).color(color).light(indicatorLight).renderInto(ms, vb);
                }
                flapBuffer.rotateCentered(Direction.UP, (float)((double)(horizontalAngle / 180.0f) * Math.PI));
                flapBuffer.translate(-flapPivotX, -flapPivotY, -flapPivotZ).rotate(Direction.SOUTH, flapAngle).translate(flapPivotX, flapPivotY, flapPivotZ);
                flapBuffer.translate(0.0f, 0.0f, (float)(-segment * 3) / 16.0f);
                flapBuffer.light(WorldRenderer.func_228420_a_((ILightReader)world, (BlockState)te.func_195044_w(), (BlockPos)pos)).renderInto(ms, vb);
            }
        }
    }
}

