/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class SpeedGaugeTileEntity
extends GaugeTileEntity {
    public SpeedGaugeTileEntity(TileEntityType<? extends SpeedGaugeTileEntity> type) {
        super(type);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.abs(this.getSpeed());
        float medium = ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get()).floatValue();
        this.color = ColorHelper.mixColors(IRotate.SpeedLevel.of(speed).getColor(), 0xFFFFFF, 0.25f);
        if (speed == 69.0f) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.SPEED_READ, this.field_145850_b, this.field_174879_c, 6, GogglesItem::canSeeParticles);
        }
        if (speed == 0.0f) {
            this.dialTarget = 0.0f;
            this.color = 0x333333;
        } else {
            this.dialTarget = speed < medium ? MathHelper.func_219799_g((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? MathHelper.func_219799_g((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : MathHelper.func_219799_g((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f));
        }
        this.func_70296_d();
    }

    @Override
    public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add("    " + TextFormatting.GRAY + Lang.translate("gui.speed_gauge.title", new Object[0]));
        tooltip.add("    " + IRotate.SpeedLevel.getFormattedSpeedText(this.speed, this.overStressed));
        if (this.overStressed) {
            tooltip.add("    " + TextFormatting.DARK_RED + Lang.translate("gui.stress_gauge.overstressed", new Object[0]));
        }
        return true;
    }
}

