/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.SimpleTrigger;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.simple.DeferralBehaviour;
import com.simibubi.create.foundation.utility.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BasinOperatingTileEntity
extends KineticTileEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected IRecipe<?> lastRecipe;
    protected LazyOptional<IItemHandler> basinInv = LazyOptional.empty();
    protected List<ItemStack> inputs;

    public BasinOperatingTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour(this, this::updateBasin);
        behaviours.add(this.basinChecker);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.basinRemoved = true;
        }
        this.basinChecker.scheduleUpdate();
    }

    public void gatherInputs() {
        if (!this.basinInv.isPresent()) {
            return;
        }
        BasinTileEntity.BasinInventory inv = (BasinTileEntity.BasinInventory)((Object)this.basinInv.orElse(null));
        this.inputs = new ArrayList<ItemStack>();
        IItemHandlerModifiable inputHandler = inv.getInputHandler();
        for (int slot = 0; slot < inputHandler.getSlots(); ++slot) {
            ItemStack itemstack = inputHandler.extractItem(slot, inputHandler.getSlotLimit(slot), true);
            if (itemstack.func_190926_b()) continue;
            this.inputs.add(itemstack);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.basinRemoved();
            this.sendData();
            return;
        }
        super.func_73660_a();
    }

    protected boolean updateBasin() {
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return false;
        }
        Optional<BasinTileEntity> basinTe = this.getBasin();
        if (!basinTe.isPresent()) {
            return true;
        }
        if (!this.basinInv.isPresent()) {
            this.basinInv = basinTe.get().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }
        if (!this.basinInv.isPresent()) {
            return true;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        this.gatherInputs();
        List<IRecipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.lastRecipe = recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    public void applyBasinRecipe() {
        if (this.lastRecipe == null) {
            return;
        }
        if (!this.basinInv.isPresent()) {
            return;
        }
        BasinTileEntity.BasinInventory inv = (BasinTileEntity.BasinInventory)((Object)this.basinInv.orElse(null));
        if (inv == null) {
            return;
        }
        IItemHandlerModifiable inputs = inv.getInputHandler();
        IItemHandlerModifiable outputs = inv.getOutputHandler();
        ArrayList<ItemStack> catalysts = new ArrayList<ItemStack>();
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        NonNullList ingredients = this.lastRecipe.func_192400_c();
        block0: for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                if (!ingredient.test(inputs.extractItem(slot, 1, true))) continue;
                ItemStack extracted = inputs.extractItem(slot, 1, false);
                if (this.lastRecipe instanceof ProcessingRecipe && ((ProcessingRecipe)this.lastRecipe).getRollableIngredients().get(i).remains()) {
                    catalysts.add(extracted.func_77946_l());
                    continue block0;
                }
                if (!extracted.hasContainerItem()) continue block0;
                containers.add(extracted.getContainerItem().func_77946_l());
                continue block0;
            }
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            SimpleTrigger trigger = AllTriggers.MIXER_MIX;
            if (AllTileEntities.MECHANICAL_PRESS.is(this)) {
                trigger = AllTriggers.PRESS_COMPACT;
            }
            AllTriggers.triggerForNearbyPlayers(trigger, this.field_145850_b, this.field_174879_c, 4);
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)outputs, (ItemStack)this.lastRecipe.func_77571_b().func_77946_l(), (boolean)false);
        containers.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)outputs, (ItemStack)stack, (boolean)false));
        catalysts.forEach(c -> ItemHandlerHelper.insertItemStacked((IItemHandler)outputs, (ItemStack)c, (boolean)false));
        this.gatherInputs();
        if (this.matchBasinRecipe(this.lastRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        this.getBasin().ifPresent(te -> {
            te.contentsChanged = true;
        });
    }

    protected List<IRecipe<?>> getMatchingRecipes() {
        List<IRecipe<?>> list = RecipeFinder.get(this.getRecipeCacheKey(), this.field_145850_b, this::matchStaticFilters);
        return list.stream().filter(this::matchBasinRecipe).sorted((r1, r2) -> -r1.func_192400_c().size() + r2.func_192400_c().size()).collect(Collectors.toList());
    }

    protected void basinRemoved() {
    }

    protected Optional<BasinTileEntity> getBasin() {
        TileEntity basinTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2));
        if (!(basinTE instanceof BasinTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((BasinTileEntity)basinTE);
    }

    protected abstract <C extends IInventory> boolean matchStaticFilters(IRecipe<C> var1);

    protected abstract <C extends IInventory> boolean matchBasinRecipe(IRecipe<C> var1);

    protected abstract Object getRecipeCacheKey();
}

