/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.content.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.content.logistics.InWorldProcessing;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.Blocks;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;

public class AirFlowParticle
extends SimpleAnimatedParticle {
    private EncasedFanTileEntity source;

    protected AirFlowParticle(World world, EncasedFanTileEntity source, double x, double y, double z, IAnimatedSprite sprite) {
        super(world, x, y, z, sprite, world.field_73012_v.nextFloat() * 0.5f);
        this.source = source;
        this.field_70544_f *= 0.75f;
        this.field_70547_e = 40;
        this.field_190017_n = false;
        this.selectSprite(7);
        Vec3d offset = VecHelper.offsetRandomly(Vec3d.field_186680_a, world.field_73012_v, 0.25f);
        this.func_187109_b(this.field_187126_f + offset.field_72450_a, this.field_187127_g + offset.field_72448_b, this.field_187128_h + offset.field_72449_c);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.func_82338_g(0.25f);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        if (this.source == null || this.source.func_145837_r()) {
            this.dissipate();
            return;
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            double distance;
            if (this.source.airCurrent == null || !this.source.airCurrent.bounds.func_186662_g(0.25).func_197744_e(this.field_187126_f, this.field_187127_g, this.field_187128_h)) {
                this.dissipate();
                return;
            }
            Vec3d directionVec = new Vec3d(this.source.airCurrent.direction.func_176730_m());
            Vec3d motion = directionVec.func_186678_a(0.125);
            if (!this.source.airCurrent.pushing) {
                motion = motion.func_186678_a(-1.0);
            }
            if ((distance = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h).func_178788_d(VecHelper.getCenterOf((Vec3i)this.source.func_174877_v())).func_216369_h(directionVec).func_72433_c() - 0.5) > (double)(this.source.airCurrent.maxDistance + 1.0f) || distance < -0.25) {
                this.dissipate();
                return;
            }
            motion = motion.func_186678_a((double)this.source.airCurrent.maxDistance - (distance - 1.0)).func_186678_a(0.5);
            this.selectSprite((int)MathHelper.func_151237_a((double)(distance / (double)this.source.airCurrent.maxDistance * 8.0 + (double)this.field_187122_b.field_73012_v.nextInt(4)), (double)0.0, (double)7.0));
            this.morphType(distance);
            this.field_187129_i = motion.field_72450_a;
            this.field_187130_j = motion.field_72448_b;
            this.field_187131_k = motion.field_72449_c;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        }
    }

    public void morphType(double distance) {
        InWorldProcessing.Type type = this.source.airCurrent.getSegmentAt((float)distance);
        if (type == InWorldProcessing.Type.SPLASHING) {
            this.func_187146_c(ColorHelper.mixColors(0x4499FF, 0x2277FF, this.field_187122_b.field_73012_v.nextFloat()));
            this.func_82338_g(1.0f);
            this.selectSprite(this.field_187122_b.field_73012_v.nextInt(3));
            if (this.field_187122_b.field_73012_v.nextFloat() < 0.03125f) {
                this.field_187122_b.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i * 0.125, this.field_187130_j * 0.125, this.field_187131_k * 0.125);
            }
            if (this.field_187122_b.field_73012_v.nextFloat() < 0.03125f) {
                this.field_187122_b.func_195594_a((IParticleData)ParticleTypes.field_203217_T, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i * 0.125, this.field_187130_j * 0.125, this.field_187131_k * 0.125);
            }
        }
        if (type == InWorldProcessing.Type.SMOKING) {
            this.func_187146_c(ColorHelper.mixColors(0, 0x555555, this.field_187122_b.field_73012_v.nextFloat()));
            this.func_82338_g(1.0f);
            this.selectSprite(this.field_187122_b.field_73012_v.nextInt(3));
            if (this.field_187122_b.field_73012_v.nextFloat() < 0.03125f) {
                this.field_187122_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i * 0.125, this.field_187130_j * 0.125, this.field_187131_k * 0.125);
            }
            if (this.field_187122_b.field_73012_v.nextFloat() < 0.03125f) {
                this.field_187122_b.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i * 0.125, this.field_187130_j * 0.125, this.field_187131_k * 0.125);
            }
        }
        if (type == InWorldProcessing.Type.BLASTING) {
            this.func_187146_c(ColorHelper.mixColors(0xFF4400, 0xFF8855, this.field_187122_b.field_73012_v.nextFloat()));
            this.func_82338_g(0.5f);
            this.selectSprite(this.field_187122_b.field_73012_v.nextInt(3));
            if (this.field_187122_b.field_73012_v.nextFloat() < 0.03125f) {
                this.field_187122_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i * 0.25, this.field_187130_j * 0.25, this.field_187131_k * 0.25);
            }
            if (this.field_187122_b.field_73012_v.nextFloat() < 0.0625f) {
                this.field_187122_b.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150353_l.func_176223_P()), this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i * 0.25, this.field_187130_j * 0.25, this.field_187131_k * 0.25);
            }
        }
        if (type == null) {
            this.func_187146_c(0xEEEEEE);
            this.func_82338_g(0.25f);
            this.func_187115_a(0.2f, 0.2f);
        }
    }

    private void dissipate() {
        this.func_187112_i();
    }

    public int func_189214_a(float partialTick) {
        BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        return this.field_187122_b.func_195588_v(blockpos) ? WorldRenderer.func_228421_a_((ILightReader)this.field_187122_b, (BlockPos)blockpos) : 0;
    }

    private void selectSprite(int index) {
        this.func_217567_a(this.field_217584_C.func_217591_a(index, 8));
    }

    public static class Factory
    implements IParticleFactory<AirFlowParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle makeParticle(AirFlowParticleData data, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TileEntity te = worldIn.func_175625_s(new BlockPos(data.posX, data.posY, data.posZ));
            if (!(te instanceof EncasedFanTileEntity)) {
                te = null;
            }
            return new AirFlowParticle(worldIn, (EncasedFanTileEntity)te, x, y, z, this.spriteSet);
        }
    }
}

