/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.waterwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class WaterWheelBlock
extends HorizontalKineticBlock
implements ITE<WaterWheelTileEntity> {
    public WaterWheelBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.WATER_WHEEL.create();
    }

    @Override
    protected boolean hasStaticPart() {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighbourPos = pos.func_177972_a(direction);
            BlockState neighbourState = worldIn.func_180495_p(neighbourPos);
            if (!AllBlocks.WATER_WHEEL.has(neighbourState) || ((Direction)neighbourState.func_177229_b(HORIZONTAL_FACING)).func_176740_k() == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k() && ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k() == direction.func_176740_k()) continue;
            return false;
        }
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        World world = worldIn.func_201672_e();
        if (world == null || worldIn instanceof WrappedWorld) {
            return stateIn;
        }
        this.updateFlowAt(stateIn, world, currentPos, facing);
        this.updateWheelSpeed(worldIn, currentPos);
        return stateIn;
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateAllSides(state, worldIn, pos);
    }

    public void updateAllSides(BlockState state, World worldIn, BlockPos pos) {
        for (Direction d : Direction.values()) {
            this.updateFlowAt(state, worldIn, pos, d);
        }
        this.updateWheelSpeed((IWorld)worldIn, pos);
    }

    private void updateFlowAt(BlockState state, World world, BlockPos pos, Direction f) {
        if (f.func_176740_k() == ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k()) {
            return;
        }
        IFluidState fluid = world.func_204610_c(pos.func_177972_a(f));
        Direction wf = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        boolean clockwise = wf.func_176743_c() == Direction.AxisDirection.POSITIVE;
        int clockwiseMultiplier = 2;
        Vec3d vec = fluid.func_215673_c((IBlockReader)world, pos.func_177972_a(f));
        vec = vec.func_186678_a((double)f.func_176743_c().func_179524_a());
        Vec3d flow = vec = new Vec3d(Math.signum(vec.field_72450_a), Math.signum(vec.field_72448_b), Math.signum(vec.field_72449_c));
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            double flowStrength = 0.0;
            if (wf.func_176740_k() == Direction.Axis.Z) {
                if (f.func_176740_k() == Direction.Axis.Y) {
                    double d = flowStrength = flow.field_72450_a > 0.0 ^ !clockwise ? -flow.field_72450_a * (double)clockwiseMultiplier : -flow.field_72450_a;
                }
                if (f.func_176740_k() == Direction.Axis.X) {
                    double d = flowStrength = flow.field_72448_b < 0.0 ^ !clockwise ? flow.field_72448_b * (double)clockwiseMultiplier : flow.field_72448_b;
                }
            }
            if (wf.func_176740_k() == Direction.Axis.X) {
                if (f.func_176740_k() == Direction.Axis.Y) {
                    double d = flowStrength = flow.field_72449_c < 0.0 ^ !clockwise ? flow.field_72449_c * (double)clockwiseMultiplier : flow.field_72449_c;
                }
                if (f.func_176740_k() == Direction.Axis.Z) {
                    double d = flowStrength = flow.field_72448_b > 0.0 ^ !clockwise ? -flow.field_72448_b * (double)clockwiseMultiplier : -flow.field_72448_b;
                }
            }
            if (te.getSpeed() == 0.0f && flowStrength != 0.0 && !world.field_72995_K) {
                AllTriggers.triggerForNearbyPlayers(AllTriggers.WATER_WHEEL, world, pos, 5);
                if (fluid.func_206886_c() == Fluids.field_207213_d || fluid.func_206886_c() == Fluids.field_204547_b) {
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.LAVA_WHEEL, world, pos, 5);
                }
            }
            te.setFlow(f, (float)(flowStrength * (double)((Integer)AllConfigs.SERVER.kinetics.waterWheelSpeed.get()).intValue() / 2.0));
        });
    }

    private void updateWheelSpeed(IWorld world, BlockPos pos) {
        this.withTileEntityDo((IBlockReader)world, pos, GeneratingKineticTileEntity::updateGeneratedRotation);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        BlockState placedOn = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(facing.func_176734_d()));
        if (AllBlocks.WATER_WHEEL.has(placedOn)) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, placedOn.func_177229_b(HORIZONTAL_FACING));
        }
        if (facing.func_176740_k().func_176722_c()) {
            return (BlockState)this.func_176223_P().func_206870_a(HORIZONTAL_FACING, (Comparable)(context.func_195999_j().func_225608_bj_() ? facing.func_176734_d() : facing));
        }
        return super.func_196258_a(context);
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k() == face.func_176740_k();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176740_k();
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public boolean hideStressImpact() {
        return true;
    }

    @Override
    public Class<WaterWheelTileEntity> getTileEntityClass() {
        return WaterWheelTileEntity.class;
    }
}

