/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AllContraptionTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerTileEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.lang3.tuple.Pair;

public class MountedContraption
extends Contraption {
    public CartAssemblerTileEntity.CartMovementMode rotationMode = CartAssemblerTileEntity.CartMovementMode.ROTATE;

    @Override
    protected AllContraptionTypes getType() {
        return AllContraptionTypes.MOUNTED;
    }

    public static MountedContraption assembleMinecart(World world, BlockPos pos) {
        if (MountedContraption.isFrozen()) {
            return null;
        }
        BlockState state = world.func_180495_p(pos);
        if (!state.func_196959_b(CartAssemblerBlock.RAIL_SHAPE)) {
            return null;
        }
        MountedContraption contraption = new MountedContraption();
        if (!contraption.searchMovedStructure(world, pos, null)) {
            return null;
        }
        Direction.Axis axis = state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE) == RailShape.EAST_WEST ? Direction.Axis.X : Direction.Axis.Z;
        contraption.add(pos, (Pair<Template.BlockInfo, TileEntity>)Pair.of((Object)new Template.BlockInfo(pos, (BlockState)AllBlocks.MINECART_ANCHOR.getDefaultState().func_206870_a((IProperty)BlockStateProperties.field_208199_z, (Comparable)axis), null), null));
        contraption.removeBlocksFromWorld((IWorld)world, BlockPos.field_177992_a);
        contraption.initActors(world);
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        return contraption;
    }

    @Override
    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction direction, List<BlockPos> frontier) {
        frontier.clear();
        frontier.add(pos.func_177984_a());
        return true;
    }

    @Override
    protected Pair<Template.BlockInfo, TileEntity> capture(World world, BlockPos pos) {
        Pair<Template.BlockInfo, TileEntity> pair = super.capture(world, pos);
        Template.BlockInfo capture = (Template.BlockInfo)pair.getKey();
        if (AllBlocks.CART_ASSEMBLER.has(capture.field_186243_b)) {
            return Pair.of((Object)new Template.BlockInfo(capture.field_186242_a, CartAssemblerBlock.createAnchor(capture.field_186243_b), null), (Object)pair.getValue());
        }
        return pair;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT writeNBT = super.writeNBT();
        writeNBT.func_74778_a("RotationMode", NBTHelper.writeEnum(this.rotationMode));
        return writeNBT;
    }

    @Override
    public void readNBT(World world, CompoundNBT nbt) {
        this.rotationMode = NBTHelper.readEnum(nbt.func_74779_i("RotationMode"), CartAssemblerTileEntity.CartMovementMode.class);
        super.readNBT(world, nbt);
    }

    @Override
    public void removeBlocksFromWorld(IWorld world, BlockPos offset) {
        super.removeBlocksFromWorld(world, offset, (pos, state) -> pos.equals((Object)this.anchor));
    }

    @Override
    public void addBlocksToWorld(World world, BlockPos offset, Vec3d rotation) {
        super.addBlocksToWorld(world, offset, rotation, (pos, state) -> AllBlocks.MINECART_ANCHOR.has((BlockState)state));
    }
}

