/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.ScreenResourceWrapper;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperUpgradeRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class BlockzapperUpgradeCategory
extends CreateRecipeCategory<BlockzapperUpgradeRecipe> {
    public BlockzapperUpgradeCategory() {
        super("blockzapper_upgrade", BlockzapperUpgradeCategory.itemIcon((IItemProvider)AllItems.BLOCKZAPPER.get()), new ScreenResourceWrapper(AllGuiTextures.BLOCKZAPPER_UPGRADE_RECIPE));
    }

    public Class<? extends BlockzapperUpgradeRecipe> getRecipeClass() {
        return BlockzapperUpgradeRecipe.class;
    }

    public void setIngredients(BlockzapperUpgradeRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, BlockzapperUpgradeRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        ShapedRecipe shape = recipe.getRecipe();
        NonNullList shapedIngredients = shape.func_192400_c();
        int top = 0;
        int left = 0;
        int i = 0;
        for (int y = 0; y < shape.getRecipeHeight(); ++y) {
            for (int x = 0; x < shape.getRecipeWidth(); ++x) {
                itemStacks.init(i, true, left + x * 18, top + y * 18);
                itemStacks.set(i, Arrays.asList(((Ingredient)shapedIngredients.get(i)).func_193365_a()));
                ++i;
            }
        }
    }

    public List<String> getTooltipStrings(BlockzapperUpgradeRecipe recipe, double mouseX, double mouseY) {
        ArrayList<String> list = new ArrayList<String>();
        if (mouseX < 91.0 || mouseX > 143.0 || mouseY < 1.0 || mouseY > 53.0) {
            return list;
        }
        list.addAll(recipe.func_77571_b().func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)).stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()));
        return list;
    }

    public void draw(BlockzapperUpgradeRecipe recipe, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String componentName = Lang.translate("blockzapper.component." + Lang.asId(recipe.getUpgradedComponent().name()), new Object[0]);
        String text = "+ " + recipe.getTier().color + componentName;
        font.func_175063_a(text, (float)((AllGuiTextures.BLOCKZAPPER_UPGRADE_RECIPE.width - font.func_78256_a(text)) / 2), 57.0f, 0x8B8B8B);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)126.0, (double)0.0, (double)0.0);
        RenderSystem.scaled((double)3.5, (double)3.5, (double)3.5);
        RenderSystem.translated((double)-10.0, (double)0.0, (double)0.0);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiGameElement.of(recipe.func_77571_b()).render();
        RenderSystem.popMatrix();
    }
}

