/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.turntable.TurntableHandler;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringHandler;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueHandler;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String itemPrefix = "item.create";
    private static final String blockPrefix = "block.create";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        AnimationTickHolder.tick();
        if (!ClientEvents.isGameActive()) {
            return;
        }
        if (!KineticDebugger.isActive() && KineticTileEntityRenderer.rainbowMode) {
            KineticTileEntityRenderer.rainbowMode = false;
            CreateClient.bufferCache.invalidate();
        }
        ScreenOpener.tick();
        CreateClient.gameTick();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        MatrixStack ms = event.getMatrixStack();
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d view = info.func_216785_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        CreateClient.schematicHandler.render(ms, buffer);
        CreateClient.outliner.renderOutlines(ms, buffer);
        buffer.draw();
        ms.func_227865_b_();
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ClientEvents.onRenderHotbar(new MatrixStack(), (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), 0xF000F0, OverlayTexture.field_229196_a_);
    }

    public static void onRenderHotbar(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        CreateClient.schematicHandler.renderOverlay(ms, buffer, light, overlay);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        boolean pressed;
        int key = event.getKey();
        boolean bl = pressed = event.getAction() != 0;
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        CreateClient.schematicHandler.onKeyInput(key, pressed);
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        double delta = event.getScrollDelta();
        boolean cancelled = CreateClient.schematicHandler.mouseScrolled(delta) || CreateClient.schematicAndQuillHandler.mouseScrolled(delta) || FilteringHandler.onScroll(delta) || ScrollValueHandler.onScroll(delta);
        event.setCanceled(cancelled);
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        int button = event.getButton();
        boolean pressed = event.getAction() != 0;
        CreateClient.schematicHandler.onMouseInput(button, pressed);
        CreateClient.schematicAndQuillHandler.onMouseInput(button, pressed);
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)AllConfigs.CLIENT.tooltips.get()).booleanValue()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.func_77973_b().func_77667_c(stack);
        if (!translationKey.startsWith(itemPrefix) && !translationKey.startsWith(blockPrefix)) {
            return;
        }
        if (TooltipHelper.hasTooltip(stack)) {
            List itemTooltip = event.getToolTip();
            ArrayList<ITextComponent> toolTip = new ArrayList<ITextComponent>();
            toolTip.add((ITextComponent)itemTooltip.remove(0));
            TooltipHelper.getTooltip(stack).addInformation(toolTip);
            itemTooltip.addAll(0, toolTip);
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderTick();
    }

    protected static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }
}

