/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.content.contraptions.particle.ICustomParticle;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public enum AllParticleTypes {
    ROTATION_INDICATOR(RotationIndicatorParticleData::new),
    AIR_FLOW(AirFlowParticleData::new);

    private ParticleEntry<?> entry;

    private <D extends IParticleData> AllParticleTypes(Supplier<? extends ICustomParticle<D>> typeFactory) {
        String asId = Lang.asId(this.name());
        this.entry = new ParticleEntry(new ResourceLocation("create", asId), typeFactory);
    }

    public static void register(RegistryEvent.Register<ParticleType<?>> event) {
        for (AllParticleTypes particle : AllParticleTypes.values()) {
            particle.entry.register(event.getRegistry());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(ParticleFactoryRegisterEvent event) {
        ParticleManager particles = Minecraft.func_71410_x().field_71452_i;
        for (AllParticleTypes particle : AllParticleTypes.values()) {
            particle.entry.registerFactory(particles);
        }
    }

    public ParticleType<?> get() {
        return this.entry.getType();
    }

    public String parameter() {
        return Lang.asId(this.name());
    }

    private class ParticleEntry<D extends IParticleData> {
        Supplier<? extends ICustomParticle<D>> typeFactory;
        ParticleType<D> type;
        ResourceLocation id;

        public ParticleEntry(ResourceLocation id, Supplier<? extends ICustomParticle<D>> typeFactory) {
            this.id = id;
            this.typeFactory = typeFactory;
        }

        ParticleType<?> getType() {
            this.makeType();
            return this.type;
        }

        void register(IForgeRegistry<ParticleType<?>> registry) {
            this.makeType();
            registry.register(this.type);
        }

        void makeType() {
            if (this.type == null) {
                this.type = this.typeFactory.get().createType();
                this.type.setRegistryName(this.id);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        void registerFactory(ParticleManager particles) {
            this.makeType();
            particles.func_215234_a(this.type, this.typeFactory.get().getFactory());
        }
    }
}

