/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.recipe.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import com.valkyrieofnight.vlib.core.util.lambda.Action1a;
import java.util.List;
import java.util.Map;

public class GsonTypesSerializer<DESERIALIZER_TYPE> {
    protected Gson gson;
    protected Map<String, ITypedDeserializer<DESERIALIZER_TYPE>> deserializerMap = Maps.newHashMap();
    protected List<String> deserializerTypeList = Lists.newArrayList();
    protected Action1a<GsonTypesSerializer<DESERIALIZER_TYPE>> addDeserializersAction;
    private boolean setup = false;

    public GsonTypesSerializer(Action1a<GsonTypesSerializer<DESERIALIZER_TYPE>> addDeserializersAction) {
        this.addDeserializersAction = addDeserializersAction;
    }

    public final void setup() {
        if (!this.setup) {
            this.setup = true;
            this.addDeserializersAction.execute(this);
            GsonBuilder gb = new GsonBuilder();
            for (ITypedDeserializer<DESERIALIZER_TYPE> td : this.deserializerMap.values()) {
                gb.registerTypeAdapter(td.getType(), td);
            }
            this.gson = gb.create();
        }
    }

    public final void addDeserializer(ITypedDeserializer<DESERIALIZER_TYPE> deserializer) {
        if (deserializer == null) {
            return;
        }
        String typeID = deserializer.getTypeIdentifier();
        if (!this.deserializerTypeList.contains(typeID)) {
            this.deserializerMap.put(typeID, deserializer);
            this.deserializerTypeList.add(typeID);
        }
    }

    public List<String> getDeserializerTypeList() {
        return this.deserializerTypeList;
    }

    public Map<String, ITypedDeserializer<DESERIALIZER_TYPE>> getDeserializerMap() {
        return this.deserializerMap;
    }

    public Gson getGson() {
        return this.gson;
    }
}

