/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib._mod.supporters.registry;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib._mod.supporters.cape.CapeType;
import com.valkyrieofnight.vlib._mod.supporters.download.SupporterRegistryThread;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public class SupporterRegistry {
    protected ConcurrentMap<UUID, CapeType> playerCapes = Maps.newConcurrentMap();
    private static SupporterRegistry INST;

    private SupporterRegistry() {
    }

    public synchronized CapeType getCapeType(UUID player) {
        return this.playerCapes.containsKey(player) ? (CapeType)this.playerCapes.get(player) : CapeType.NONE;
    }

    public synchronized void register(UUID player, CapeType cape) {
        if (player == null || cape == null) {
            return;
        }
        this.playerCapes.put(player, cape);
    }

    public static SupporterRegistry getInstance() {
        if (INST == null) {
            INST = new SupporterRegistry();
        }
        return INST;
    }

    public void reload() {
        this.playerCapes = Maps.newConcurrentMap();
        SupporterRegistryThread SR = new SupporterRegistryThread(this);
        SR.start();
    }
}

