/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.util;

import com.chaosthedude.endermail.config.ConfigHandler;
import com.chaosthedude.endermail.util.OverlaySide;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FontRenderer fontRenderer = RenderUtils.mc.field_71466_p;

    public static void drawStringLeft(String string, FontRenderer fontRenderer, int x, int y, int color) {
        fontRenderer.func_175063_a(string, (float)x, (float)y, color);
    }

    public static void drawStringRight(String string, FontRenderer fontRenderer, int x, int y, int color) {
        fontRenderer.func_175063_a(string, (float)(x - fontRenderer.func_78256_a(string)), (float)y, color);
    }

    public static void drawConfiguredStringOnHUD(String string, int xOffset, int yOffset, int color, int relativeLineOffset) {
        int lineOffset = (Integer)ConfigHandler.CLIENT.lineOffset.get() + relativeLineOffset;
        yOffset += lineOffset * 9;
        if (ConfigHandler.CLIENT.overlaySide.get() == OverlaySide.LEFT) {
            RenderUtils.drawStringLeft(string, fontRenderer, xOffset + 2, yOffset + 2, color);
        } else {
            RenderUtils.drawStringRight(string, fontRenderer, mc.func_228018_at_().func_198107_o() - xOffset - 2, yOffset + 2, color);
        }
    }

    public static void drawCenteredStringWithoutShadow(String string, int x, int y, int color) {
        fontRenderer.func_211126_b(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, color);
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + height), 0.0).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + 0), 0.0).func_225583_a_((float)(textureX + width) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225583_a_((float)(textureX + 0) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        int temp;
        if (left < right) {
            temp = left;
            left = right;
            right = temp;
        }
        if (top < bottom) {
            temp = top;
            top = bottom;
            bottom = temp;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_181675_d();
        buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_181675_d();
        buffer.func_225582_a_((double)right, (double)top, 0.0).func_181675_d();
        buffer.func_225582_a_((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

