/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.items;

import com.chaosthedude.endermail.util.ControllerState;
import com.chaosthedude.endermail.util.ItemUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PackageControllerItem
extends Item {
    public static final String NAME = "package_controller";

    public PackageControllerItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
        this.func_185043_a(new ResourceLocation("state"), new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
                return PackageControllerItem.this.getState(stack).getID();
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            this.setState(player.func_184586_b(hand), ControllerState.DEFAULT);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void setState(ItemStack stack, ControllerState state) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("State", state.getID());
        }
    }

    public void setDeliveryPos(ItemStack stack, BlockPos pos) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("DeliveryX", pos.func_177958_n());
            stack.func_77978_p().func_74768_a("DeliveryY", pos.func_177956_o());
            stack.func_77978_p().func_74768_a("DeliveryZ", pos.func_177952_p());
        }
    }

    public void setDeliveryDistance(ItemStack stack, int distance) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("DeliveryDistance", distance);
        }
    }

    public void setMaxDistance(ItemStack stack, int distance) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.func_77978_p().func_74768_a("MaxDistance", distance);
        }
    }

    public ControllerState getState(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return ControllerState.fromID(stack.func_77978_p().func_74762_e("State"));
        }
        return null;
    }

    public BlockPos getDeliveryPos(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return new BlockPos(stack.func_77978_p().func_74762_e("DeliveryX"), stack.func_77978_p().func_74762_e("DeliveryY"), stack.func_77978_p().func_74762_e("DeliveryZ"));
        }
        return null;
    }

    public int getDeliveryDistance(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("DeliveryDistance");
        }
        return -1;
    }

    public int getMaxDistance(ItemStack stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.func_77978_p().func_74762_e("MaxDistance");
        }
        return -1;
    }
}

