/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.handler;

import com.maciej916.maenchants.capabilities.IEnchants;
import com.maciej916.maenchants.init.ModEnchants;
import com.maciej916.maenchants.network.Networking;
import com.maciej916.maenchants.network.PacketMultiJumpDo;
import com.maciej916.maenchants.network.PacketMultiJumpSync;
import com.maciej916.maenchants.utils.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.network.NetworkDirection;

public class HandlerMultiJump {
    public static void handlerPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.field_70122_E) {
            IEnchants enchantsCap = PlayerUtil.getAliveEnchantsCapability(event.player);
            if (enchantsCap == null) {
                return;
            }
            enchantsCap.setMultiJump(0);
        }
    }

    public static void handlerLoggedIn(ServerPlayerEntity player) {
        IEnchants enchantsCap = PlayerUtil.getAliveEnchantsCapability((PlayerEntity)player);
        if (enchantsCap == null) {
            return;
        }
        int jumps = enchantsCap.getMultiJump();
        if (jumps > 0) {
            Networking.INSTANCE.sendTo((Object)new PacketMultiJumpSync(jumps), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private static void handlerJumpClient(PlayerEntity player) {
        if (HandlerMultiJump.handlerJump(player)) {
            Networking.INSTANCE.sendToServer((Object)new PacketMultiJumpDo());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlerKeyInput(Minecraft mc, InputEvent.KeyInputEvent event) {
        if (!mc.func_195544_aj() || mc.field_71441_e == null) {
            return;
        }
        IEnchants enchantsCap = PlayerUtil.getAliveEnchantsCapability((PlayerEntity)mc.field_71439_g);
        if (enchantsCap == null) {
            return;
        }
        boolean down = mc.field_71474_y.field_74314_A.func_151470_d();
        if (down) {
            if (!enchantsCap.getMultiJumpSpace()) {
                enchantsCap.setMultiJumpSpace(true);
                HandlerMultiJump.handlerJumpClient((PlayerEntity)mc.field_71439_g);
            }
        } else {
            enchantsCap.setMultiJumpSpace(false);
        }
    }

    public static boolean handlerJump(PlayerEntity player) {
        ItemStack stack = player.func_184582_a(EquipmentSlotType.FEET);
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)ModEnchants.MULTI_JUMP, (ItemStack)stack);
        if (lvl == 0 || !HandlerMultiJump.allowJump(player)) {
            return false;
        }
        IEnchants enchantsCap = PlayerUtil.getAliveEnchantsCapability(player);
        if (enchantsCap == null) {
            return false;
        }
        int jumps = enchantsCap.getMultiJump();
        if (jumps < lvl) {
            enchantsCap.setMultiJump(++jumps);
            player.func_70664_aZ();
            HandlerMultiJump.extraExhaustion(player);
            return true;
        }
        return false;
    }

    private static boolean allowJump(PlayerEntity player) {
        boolean fallFlyingReady;
        boolean insideLiquid;
        if (player.func_213453_ef()) {
            return false;
        }
        boolean performingAction = player.field_70122_E || player.func_184207_aI() || player.field_71075_bZ.field_75100_b || player.field_71075_bZ.field_75101_c;
        boolean bl = insideLiquid = player.func_70090_H() || player.func_180799_ab();
        if (performingAction || insideLiquid) {
            return false;
        }
        ItemStack itemstack = player.func_184582_a(EquipmentSlotType.CHEST);
        boolean bl2 = fallFlyingReady = !player.func_184613_cA() && itemstack.func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d((ItemStack)itemstack);
        return !fallFlyingReady;
    }

    private static void extraExhaustion(PlayerEntity player) {
        if (player.func_70051_ag()) {
            player.func_71020_j(0.6f);
        } else {
            player.func_71020_j(0.15f);
        }
    }
}

