/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.refinedmods.refinedpipes.block.FluidPipeBlock;
import com.refinedmods.refinedpipes.render.CubeBuilder;
import com.refinedmods.refinedpipes.tile.FluidPipeTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidPipeTileEntityRenderer
extends TileEntityRenderer<FluidPipeTileEntity> {
    private static final float INSET = 0.001f;

    public FluidPipeTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FluidPipeTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferType, int combinedLight, int combinedOverlay) {
        float shrinkage;
        float z2;
        float y2;
        float x2;
        float z1;
        float y1;
        float x1;
        FluidStack fluidStack = tile.getFluid();
        if (fluidStack.isEmpty()) {
            tile.updateAndGetRenderFullness(partialTicks);
            return;
        }
        int light = WorldRenderer.func_228421_a_((ILightReader)tile.func_145831_w(), (BlockPos)tile.func_174877_v());
        FluidAttributes attributes = fluidStack.getFluid().getAttributes();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(attributes.getStillTexture(fluidStack));
        int fluidColor = attributes.getColor(fluidStack);
        int r = fluidColor >> 16 & 0xFF;
        int g = fluidColor >> 8 & 0xFF;
        int b = fluidColor & 0xFF;
        int a = fluidColor >> 24 & 0xFF;
        IVertexBuilder buffer = bufferType.getBuffer(RenderType.func_228658_l_((ResourceLocation)sprite.func_229241_m_().func_229223_g_()));
        float fullness = tile.updateAndGetRenderFullness(partialTicks);
        if (fullness == 0.0f) {
            return;
        }
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.NORTH)).booleanValue()) {
            x1 = 4.0f;
            y1 = 4.0f;
            z1 = 0.0f;
            x2 = 12.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 4.0f;
            CubeBuilder.INSTANCE.putCube(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.EAST)).booleanValue()) {
            x1 = 12.0f;
            y1 = 4.0f;
            z1 = 4.0f;
            x2 = 16.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 12.0f;
            CubeBuilder.INSTANCE.putCube(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.SOUTH)).booleanValue()) {
            x1 = 4.0f;
            y1 = 4.0f;
            z1 = 12.0f;
            x2 = 12.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 16.0f;
            CubeBuilder.INSTANCE.putCube(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.WEST)).booleanValue()) {
            x1 = 0.0f;
            y1 = 4.0f;
            z1 = 4.0f;
            x2 = 4.0f;
            y2 = 4.0f + fullness * 8.0f;
            z2 = 12.0f;
            CubeBuilder.INSTANCE.putCube(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.UP)).booleanValue()) {
            x1 = 4.0f;
            y1 = 12.0f;
            z1 = 4.0f;
            x2 = 12.0f;
            y2 = 16.0f;
            z2 = 12.0f;
            shrinkage = (1.0f - fullness) * 4.0f;
            CubeBuilder.INSTANCE.putCube(matrixStack, buffer, (x1 += shrinkage) / 16.0f + 0.001f, (y1 -= (1.0f - fullness) * 8.0f) / 16.0f + 0.001f, (z1 += shrinkage) / 16.0f + 0.001f, (x2 -= shrinkage) / 16.0f - 0.001f, y2 / 16.0f - 0.001f, (z2 -= shrinkage) / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.DOWN);
        }
        if (((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.DOWN)).booleanValue()) {
            x1 = 4.0f;
            y1 = 0.0f;
            z1 = 4.0f;
            x2 = 12.0f;
            y2 = 4.0f;
            z2 = 12.0f;
            shrinkage = (1.0f - fullness) * 4.0f;
            CubeBuilder.INSTANCE.putCube(matrixStack, buffer, (x1 += shrinkage) / 16.0f + 0.001f, y1 / 16.0f + 0.001f, (z1 += shrinkage) / 16.0f + 0.001f, (x2 -= shrinkage) / 16.0f - 0.001f, y2 / 16.0f - 0.001f, (z2 -= shrinkage) / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.UP);
        }
        x1 = 4.0f;
        y1 = 4.0f;
        z1 = 4.0f;
        x2 = 12.0f;
        y2 = 4.0f + fullness * 8.0f;
        z2 = 12.0f;
        matrixStack.func_227860_a_();
        CubeBuilder.INSTANCE.putFace(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.UP);
        CubeBuilder.INSTANCE.putFace(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.DOWN);
        if (!((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.NORTH)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.NORTH);
        }
        if (!((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.EAST)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.EAST);
        }
        if (!((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.SOUTH)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.SOUTH);
        }
        if (!((Boolean)state.func_177229_b((IProperty)FluidPipeBlock.WEST)).booleanValue()) {
            CubeBuilder.INSTANCE.putFace(matrixStack, buffer, x1 / 16.0f + 0.001f, y1 / 16.0f + 0.001f, z1 / 16.0f + 0.001f, x2 / 16.0f - 0.001f, y2 / 16.0f - 0.001f, z2 / 16.0f - 0.001f, r, g, b, a, light, sprite, Direction.WEST);
        }
        matrixStack.func_227865_b_();
    }
}

