/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import com.blakebr0.mysticalagradditions.item.CreativeEssenceItem;
import com.blakebr0.mysticalagradditions.item.EssenceCoalItem;
import com.blakebr0.mysticalagradditions.item.EssencePaxelItem;
import com.blakebr0.mysticalagradditions.item.WitheringSoulItem;
import com.blakebr0.mysticalagradditions.lib.ModItemTier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    public static final List<Supplier<Item>> BLOCK_ENTRIES = new ArrayList<Supplier<Item>>();
    public static final Map<RegistryObject<Item>, Supplier<Item>> ENTRIES = new LinkedHashMap<RegistryObject<Item>, Supplier<Item>>();
    public static final RegistryObject<Item> INSANIUM_ESSENCE = ModItems.register("insanium_essence");
    public static final RegistryObject<Item> INSANIUM_INGOT = ModItems.register("insanium_ingot");
    public static final RegistryObject<Item> INSANIUM_NUGGET = ModItems.register("insanium_nugget");
    public static final RegistryObject<Item> INSANIUM_GEMSTONE = ModItems.register("insanium_gemstone");
    public static final RegistryObject<Item> NETHER_STAR_SHARD = ModItems.register("nether_star_shard");
    public static final RegistryObject<Item> WITHERING_SOUL = ModItems.register("withering_soul", () -> new WitheringSoulItem(p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> DRAGON_EGG_CHUNK = ModItems.register("dragon_egg_chunk");
    public static final RegistryObject<Item> DRAGON_SCALE = ModItems.register("dragon_scale");
    public static final RegistryObject<Item> CREATIVE_ESSENCE = ModItems.register("creative_essence", () -> new CreativeEssenceItem(p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> INFERIUM_COAL = ModItems.register("inferium_coal", () -> new EssenceCoalItem(2400, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> PRUDENTIUM_COAL = ModItems.register("prudentium_coal", () -> new EssenceCoalItem(4800, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> TERTIUM_COAL = ModItems.register("tertium_coal", () -> new EssenceCoalItem(9600, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> IMPERIUM_COAL = ModItems.register("imperium_coal", () -> new EssenceCoalItem(19200, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> SUPREMIUM_COAL = ModItems.register("supremium_coal", () -> new EssenceCoalItem(38400, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> INSANIUM_COAL = ModItems.register("insanium_coal", () -> new EssenceCoalItem(76800, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> INFERIUM_PAXEL = ModItems.register("inferium_paxel", () -> new EssencePaxelItem(ModItemTier.INFERIUM, 1, 1, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> PRUDENTIUM_PAXEL = ModItems.register("prudentium_paxel", () -> new EssencePaxelItem(ModItemTier.PRUDENTIUM, 2, 1, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> TERTIUM_PAXEL = ModItems.register("tertium_paxel", () -> new EssencePaxelItem(ModItemTier.TERTIUM, 3, 1, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> IMPERIUM_PAXEL = ModItems.register("imperium_paxel", () -> new EssencePaxelItem(ModItemTier.IMPERIUM, 4, 1, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    public static final RegistryObject<Item> SUPREMIUM_PAXEL = ModItems.register("supremium_paxel", () -> new EssencePaxelItem(ModItemTier.SUPREMIUM, 5, 1, p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCK_ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        ENTRIES.forEach((reg, item) -> {
            registry.register((IForgeRegistryEntry)item.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Item> register(String name) {
        return ModItems.register(name, () -> new BaseItem(p -> p.func_200916_a(MysticalAgradditions.ITEM_GROUP)));
    }

    private static RegistryObject<Item> register(String name, Supplier<Item> item) {
        ResourceLocation loc = new ResourceLocation("mysticalagradditions", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.ITEMS);
        ENTRIES.put((RegistryObject<Item>)reg, () -> (Item)((Item)item.get()).setRegistryName(loc));
        return reg;
    }
}

