/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.item;

import com.blakebr0.mysticalagradditions.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class EssencePaxelItem
extends ToolItem
implements ITinkerable {
    private static final Map<Block, BlockState> PATH_STUFF = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.TOOL, AugmentType.PICKAXE, AugmentType.SHOVEL, AugmentType.AXE);
    private final int tinkerableTier;
    private final int slots;

    public EssencePaxelItem(IItemTier tier, int tinkerableTier, int slots, Function<Item.Properties, Item.Properties> properties) {
        super(4.0f, -3.2f, tier, new HashSet(), properties.apply(new Item.Properties().func_200915_b((int)((double)tier.func_200926_a() * 1.5)).addToolType(ToolType.PICKAXE, tier.func_200925_d()).addToolType(ToolType.SHOVEL, tier.func_200925_d()).addToolType(ToolType.AXE, tier.func_200925_d())));
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public boolean func_150897_b(BlockState state) {
        Block block = state.func_177230_c();
        int i = this.func_200891_e().func_200925_d();
        if (state.getHarvestTool() == ToolType.PICKAXE) {
            return i >= state.getHarvestLevel();
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e && material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_215713_z ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState state;
        ItemStack stack = context.func_195996_i();
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onItemUse(context)) continue;
            success = true;
        }
        if (success) {
            return ActionResultType.SUCCESS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (context.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a()) && (state = PATH_STUFF.get(world.func_180495_p(pos).func_177230_c())) != null) {
            PlayerEntity player = context.func_195999_j();
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, state, 11);
                if (player != null) {
                    stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onRightClick(stack, world, player, hand)) continue;
            success = true;
        }
        if (success) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onRightClickEntity(stack, player, target, hand)) continue;
            success = true;
        }
        return success;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onHitEntity(stack, target, attacker)) continue;
            success = true;
        }
        return success;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        super.func_179218_a(stack, world, state, pos, entity);
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onBlockDestroyed(stack, world, state, pos, entity)) continue;
            success = true;
        }
        return success;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        List augments = AugmentUtils.getAugments((ItemStack)stack);
        boolean success = false;
        for (IAugment augment : augments) {
            if (!augment.onBlockStartBreak(stack, pos, player)) continue;
            success = true;
        }
        return success;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        AugmentUtils.getAugments((ItemStack)stack).forEach(a -> a.onInventoryTick(stack, world, entity, slot, isSelected));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        AugmentUtils.getAugments((ItemStack)stack).forEach(a -> tooltip.add(a.getDisplayName()));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, AttributeModifier.Operation.ADDITION));
            AugmentUtils.getAugments((ItemStack)stack).forEach(arg_0 -> EssencePaxelItem.lambda$getAttributeModifiers$3((Multimap)modifiers, slot, stack, arg_0));
        }
        return modifiers;
    }

    public int getAugmentSlots() {
        return this.slots;
    }

    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    public int getTinkerableTier() {
        return this.tinkerableTier;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$3(Multimap modifiers, EquipmentSlotType slot, ItemStack stack, IAugment a) {
        a.addToolAttributeModifiers(modifiers, slot, stack);
    }
}

