/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IPartMaterial;
import net.silentchaos512.gear.api.material.MaterialDisplay;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.parts.PartTextureType;

public class PartMaterial
implements IPartMaterial {
    private final ResourceLocation materialId;
    private Ingredient ingredient = Ingredient.field_193370_a;
    boolean visible = true;
    int tier = -1;
    Map<PartType, StatModifierMap> stats = new HashMap<PartType, StatModifierMap>();
    Map<PartType, List<PartTraitInstance>> traits = new HashMap<PartType, List<PartTraitInstance>>();
    ITextComponent displayName;
    @Nullable
    ITextComponent namePrefix = null;
    final Map<String, MaterialDisplay> display = new HashMap<String, MaterialDisplay>();

    public PartMaterial(ResourceLocation id) {
        this.materialId = id;
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    public int getTier(PartType partType) {
        return this.tier;
    }

    @Override
    public Ingredient getIngredient(PartType partType) {
        return this.ingredient;
    }

    @Override
    public boolean allowedInPart(PartType partType) {
        return this.stats.containsKey(partType);
    }

    @Override
    public void retainData(@Nullable IPartMaterial oldMaterial) {
        if (oldMaterial instanceof PartMaterial) {
            this.traits.clear();
            ((PartMaterial)oldMaterial).traits.forEach((partType, list) -> this.traits.put((PartType)partType, (List<PartTraitInstance>)list));
        }
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartType partType) {
        return this.stats.get(partType).get(stat);
    }

    @Override
    public Collection<PartTraitInstance> getTraits(ItemStack gear, PartType partType) {
        return Collections.unmodifiableList(this.traits.getOrDefault(partType, Collections.emptyList()));
    }

    @Override
    public int getColor(ItemStack gear, PartType partType) {
        return this.getMaterialDisplay(gear, partType).getColor();
    }

    @Override
    public PartTextureType getTexture(ItemStack gear, PartType partType) {
        return this.getMaterialDisplay(gear, partType).getTexture();
    }

    private MaterialDisplay getMaterialDisplay(ItemStack gear, PartType partType) {
        if (!gear.func_190926_b()) {
            GearType gearType = ((ICoreItem)gear.func_77973_b()).getGearType();
            String gearTypeKey = partType + "/" + gearType.getName();
            if (this.display.containsKey(gearTypeKey)) {
                return this.display.get(gearTypeKey);
            }
            for (String key : this.display.keySet()) {
                if (!gearType.matches(key, false)) continue;
                return this.display.get(key);
            }
        }
        return this.display.getOrDefault(partType + "/all", MaterialDisplay.DEFAULT);
    }

    @Override
    public ITextComponent getDisplayName(ItemStack gear, PartType partType) {
        return this.displayName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return "PartMaterial{id=" + this.materialId + ", tier=" + this.tier + ", ingredient=" + this.ingredient + '}';
    }

    public static final class Serializer {
        private Serializer() {
            throw new IllegalAccessError("Utility class");
        }

        public static PartMaterial deserialize(ResourceLocation id, JsonObject json) {
            JsonElement elementDisplay;
            JsonElement craftingItems;
            PartMaterial ret = new PartMaterial(id);
            Serializer.readStats(json, ret);
            JsonElement elementTraits = json.get("traits");
            if (elementTraits != null && elementTraits.isJsonArray()) {
                JsonArray array = elementTraits.getAsJsonArray();
                ArrayList<PartTraitInstance> traitsList = new ArrayList<PartTraitInstance>();
                for (JsonElement element : array) {
                    traitsList.add(PartTraitInstance.deserialize(element.getAsJsonObject()));
                }
                if (!traitsList.isEmpty()) {
                    // empty if block
                }
            }
            if ((craftingItems = json.get("crafting_items")) != null && craftingItems.isJsonObject()) {
                JsonElement main = craftingItems.getAsJsonObject().get("main");
                if (main != null) {
                    ret.ingredient = Ingredient.func_199802_a((JsonElement)main);
                }
            } else {
                throw new JsonSyntaxException("Expected 'crafting_items' to be an object");
            }
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            ret.displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                ret.namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
            if ((elementDisplay = json.get("display")) != null && elementDisplay.isJsonObject()) {
                JsonObject obj = elementDisplay.getAsJsonObject();
                MaterialDisplay defaultProps = ret.display.getOrDefault("all", MaterialDisplay.DEFAULT);
                if (!ret.display.containsKey("all")) {
                    ret.display.put("all", defaultProps);
                }
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (!value.isJsonObject()) continue;
                    JsonObject jsonObject = value.getAsJsonObject();
                    ret.display.put(key, MaterialDisplay.deserialize(jsonObject, defaultProps));
                }
            } else {
                throw new JsonSyntaxException("Expected 'display' to be an object");
            }
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability == null || !elementAvailability.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'availability' to be an object");
            }
            JsonObject obj = elementAvailability.getAsJsonObject();
            ret.tier = JSONUtils.func_151208_a((JsonObject)obj, (String)"tier", (int)ret.tier);
            ret.visible = JSONUtils.func_151209_a((JsonObject)obj, (String)"visible", (boolean)ret.visible);
            return ret;
        }

        public static void readStats(JsonObject json, PartMaterial ret) {
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonObject()) {
                for (Map.Entry entry : elementStats.getAsJsonObject().entrySet()) {
                    ResourceLocation partTypeName = SilentGear.getIdWithDefaultNamespace((String)entry.getKey());
                    if (partTypeName == null) continue;
                    PartType partType = PartType.get(partTypeName);
                    StatModifierMap statMods = StatModifierMap.read((JsonElement)entry.getValue());
                    ret.stats.put(partType, statMods);
                }
            }
        }

        private static ITextComponent deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = JSONUtils.func_151209_a((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslationTextComponent(name, new Object[0]) : new StringTextComponent(name);
            }
            return Objects.requireNonNull(ITextComponent.Serializer.func_197672_a((JsonElement)json));
        }

        @Nullable
        private static JsonArray getGearBlacklist(JsonObject json) {
            if (json.has("gear_blacklist")) {
                return JSONUtils.func_151214_t((JsonObject)json, (String)"gear_blacklist");
            }
            if (json.has("tool_blacklist")) {
                return JSONUtils.func_151214_t((JsonObject)json, (String)"tool_blacklist");
            }
            return null;
        }
    }
}

