/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IPartMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.PartMaterial;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MaterialManager
implements IResourceManagerReloadListener {
    public static final MaterialManager INSTANCE = new MaterialManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"MaterialManager");
    private static final String DATA_PATH = "silentgear_materials";
    private static final Map<ResourceLocation, IPartMaterial> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<ResourceLocation> ERROR_LIST = new ArrayList<ResourceLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IPartMaterial> map = MAP;
        synchronized (map) {
            MAP.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading material files");
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(DATA_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load material {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            SilentGear.LOGGER.info("Skipping loading material {} as its conditions were not met", (Object)name);
                            continue;
                        }
                        PartMaterial material = PartMaterial.Serializer.deserialize(name, json);
                        MAP.put(material.getId(), material);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(name);
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IPartMaterial> getValues() {
        Map<ResourceLocation, IPartMaterial> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IPartMaterial get(@Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        Map<ResourceLocation, IPartMaterial> map = MAP;
        synchronized (map) {
            return MAP.get(id);
        }
    }

    @Nullable
    public static IPartMaterial from(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IPartMaterial material : MaterialManager.getValues()) {
            if (!material.getIngredient(PartType.MAIN).test(stack)) continue;
            return material;
        }
        return null;
    }

    public static Collection<ITextComponent> getErrorMessages(ServerPlayerEntity player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = ERROR_LIST.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return ImmutableList.of((Object)new StringTextComponent("[Silent Gear] The following materials failed to load, check your log file:").func_211708_a(TextFormatting.RED), (Object)new StringTextComponent(listStr));
        }
        return ImmutableList.of();
    }
}

