/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.item.CustomTippedUpgrade;

public final class CustomTippedUpgradeIngredient
extends Ingredient {
    private final ResourceLocation partId;

    private CustomTippedUpgradeIngredient(ResourceLocation partId) {
        super(Stream.of(new Ingredient.SingleItemList(CustomTippedUpgrade.getStack(partId))));
        this.partId = partId;
    }

    public static CustomTippedUpgradeIngredient of(ResourceLocation partId) {
        return new CustomTippedUpgradeIngredient(partId);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof CustomTippedUpgrade)) {
            return false;
        }
        return this.partId.equals((Object)CustomTippedUpgrade.getPartId(stack));
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements IIngredientSerializer<CustomTippedUpgradeIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = SilentGear.getId("custom_tipped_upgrade");

        private Serializer() {
        }

        public CustomTippedUpgradeIngredient parse(PacketBuffer buffer) {
            return new CustomTippedUpgradeIngredient(buffer.func_192575_l());
        }

        public CustomTippedUpgradeIngredient parse(JsonObject json) {
            ResourceLocation partId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"part"));
            return new CustomTippedUpgradeIngredient(partId);
        }

        public void write(PacketBuffer buffer, CustomTippedUpgradeIngredient ingredient) {
            buffer.func_192572_a(ingredient.partId);
        }
    }
}

