/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fluids;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class PotionFluid
extends Fluid {
    public PotionFluid() {
        this.setRegistryName("immersiveengineering", "potion");
        IEContent.registeredIEFluids.add(this);
    }

    @Nonnull
    public Item func_204524_b() {
        return Items.field_190931_a;
    }

    protected boolean func_215665_a(@Nonnull IFluidState p_215665_1_, @Nonnull IBlockReader p_215665_2_, @Nonnull BlockPos p_215665_3_, @Nonnull Fluid p_215665_4_, @Nonnull Direction p_215665_5_) {
        return true;
    }

    @Nonnull
    protected Vec3d func_215663_a(@Nonnull IBlockReader p_215663_1_, @Nonnull BlockPos p_215663_2_, @Nonnull IFluidState p_215663_3_) {
        return Vec3d.field_186680_a;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 0;
    }

    protected float func_210195_d() {
        return 0.0f;
    }

    public float func_215662_a(@Nonnull IFluidState p_215662_1_, @Nonnull IBlockReader p_215662_2_, @Nonnull BlockPos p_215662_3_) {
        return 0.0f;
    }

    public float func_223407_a(@Nonnull IFluidState p_223407_1_) {
        return 0.0f;
    }

    @Nonnull
    protected BlockState func_204527_a(@Nonnull IFluidState state) {
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_207193_c(@Nonnull IFluidState state) {
        return true;
    }

    public int func_207192_d(@Nonnull IFluidState p_207192_1_) {
        return 0;
    }

    @Nonnull
    public VoxelShape func_215664_b(@Nonnull IFluidState p_215664_1_, @Nonnull IBlockReader p_215664_2_, @Nonnull BlockPos p_215664_3_) {
        return VoxelShapes.func_197880_a();
    }

    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)IEDataGenerator.rl("block/fluid/potion_still"), (ResourceLocation)IEDataGenerator.rl("block/fluid/potion_flowing"));
        return new PotionFluidAttributes(builder, this);
    }

    public void addInformation(FluidStack fluidStack, List<ITextComponent> tooltip) {
        if (fluidStack != null && fluidStack.hasTag()) {
            List effects = PotionUtils.func_185185_a((CompoundNBT)fluidStack.getTag());
            if (effects.isEmpty()) {
                tooltip.add(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
            } else {
                for (EffectInstance instance : effects) {
                    TranslationTextComponent itextcomponent = new TranslationTextComponent(instance.func_76453_d(), new Object[0]);
                    Effect effect = instance.func_188419_a();
                    if (instance.func_76458_c() > 0) {
                        itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + instance.func_76458_c(), new Object[0]));
                    }
                    if (instance.func_76459_b() > 20) {
                        itextcomponent.func_150258_a(" (").func_150258_a(EffectUtils.func_188410_a((EffectInstance)instance, (float)1.0f)).func_150258_a(")");
                    }
                    tooltip.add(itextcomponent.func_211708_a(effect.func_220303_e().func_220306_a()));
                }
            }
            Potion potionType = PotionUtils.func_185187_c((CompoundNBT)fluidStack.getTag());
            if (potionType != Potions.field_185229_a) {
                String modID = potionType.getRegistryName().func_110624_b();
                tooltip.add(new TranslationTextComponent("desc.immersiveengineering.info.potionMod", new Object[]{Utils.getModName(modID)}).func_211708_a(TextFormatting.DARK_GRAY));
            }
        }
    }

    public static class PotionFluidAttributes
    extends FluidAttributes {
        protected PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public ITextComponent getDisplayName(FluidStack stack) {
            if (stack == null || !stack.hasTag()) {
                return super.getDisplayName(stack);
            }
            return new TranslationTextComponent(PotionUtils.func_185187_c((CompoundNBT)stack.getTag()).func_185174_b("item.minecraft.potion.effect."), new Object[0]);
        }

        public int getColor(FluidStack stack) {
            if (stack == null || !stack.hasTag()) {
                return -16776961;
            }
            return 0xFF000000 | PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((CompoundNBT)stack.getTag()));
        }
    }
}

