/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CoresampleItem
extends IEBaseItem {
    public CoresampleItem() {
        super("coresample", new Item.Properties().func_200916_a(ImmersiveEngineering.itemGroup));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        DimensionChunkCoords coords = DimensionChunkCoords.readFromNBT(stack.func_196082_o().func_74775_l("coords"));
        if (coords != null) {
            if (ItemNBTHelper.hasKey(stack, "mineral")) {
                String loc;
                ResourceLocation rl = new ResourceLocation(ItemNBTHelper.getString(stack, "mineral"));
                ExcavatorHandler.MineralMix mineral = ExcavatorHandler.mineralList.get(rl);
                String unloc = mineral.getTranslationKey();
                if (unloc.equals(loc = I18n.func_135052_a((String)unloc, (Object[])new Object[0]))) {
                    loc = mineral.getPlainName();
                }
                list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.mineral", new Object[]{loc}));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.noMineral", new Object[0]));
            }
            if (world == null || world.func_201675_m().func_186058_p() != coords.dimension) {
                ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
                world = clientWorld != null && clientWorld.func_201675_m().func_186058_p() == coords.dimension ? clientWorld : null;
            }
            String s0 = coords.field_77276_a * 16 + ", " + coords.field_77275_b * 16;
            String s1 = coords.field_77276_a * 16 + 16 + ", " + (coords.field_77275_b * 16 + 16);
            String s2 = coords.dimension.getRegistryName().func_110623_a();
            if (s2.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                s2 = s2.substring(4);
            }
            list.add((ITextComponent)new StringTextComponent(Utils.toCamelCase(s2)));
            list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.pos", new Object[]{s0, s1, ""}));
            if (ItemNBTHelper.hasKey(stack, "infinite")) {
                list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.infinite", new Object[0]));
            } else if (ItemNBTHelper.hasKey(stack, "depletion")) {
                list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.yield", new Object[]{ExcavatorHandler.mineralVeinCapacity - ItemNBTHelper.getInt(stack, "depletion")}));
            }
            boolean hasStamp = ItemNBTHelper.hasKey(stack, "timestamp");
            if (hasStamp && world != null) {
                long timestamp = ItemNBTHelper.getLong(stack, "timestamp");
                long dist = world.func_82737_E() - timestamp;
                if (dist < 0L) {
                    list.add((ITextComponent)new StringTextComponent("Somehow this sample is dated in the future...are you a time traveller?!"));
                } else {
                    list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.timestamp", new Object[]{ClientUtils.fomatTimestamp(dist, ClientUtils.TimestampFormat.DHM)}));
                }
            } else if (hasStamp) {
                list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.timezone", new Object[0]));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.info.coresample.noTimestamp", new Object[0]));
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        if (player != null && player.func_225608_bj_()) {
            BlockItemUseContext blockCtx;
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            Direction side = ctx.func_196000_l();
            BlockState state = world.func_180495_p(pos);
            if (!state.func_196953_a(blockCtx = new BlockItemUseContext(ctx))) {
                pos = pos.func_177972_a(side);
            }
            if (!stack.func_190926_b() && player.func_175151_a(pos, side, stack) && world.func_180495_p(pos).func_196953_a(blockCtx)) {
                BlockState coresample = IEBlocks.StoneDecoration.coresample.func_176223_P();
                if (world.func_180501_a(pos, coresample, 3)) {
                    ((IEBaseBlock)IEBlocks.StoneDecoration.coresample).onIEBlockPlacedBy(blockCtx, coresample);
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(ctx);
    }
}

