/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.data.loot.LootGenerator;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.loot.DropInventoryLootEntry;
import blusunrize.immersiveengineering.common.util.loot.MBOriginalBlockLootEntry;
import blusunrize.immersiveengineering.common.util.loot.TileDropLootEntry;
import blusunrize.immersiveengineering.common.util.loot.WindmillLootFunction;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class BlockLoot
extends LootGenerator {
    public BlockLoot(DataGenerator gen) {
        super(gen);
    }

    @Nonnull
    public String func_200397_b() {
        return "LootTablesBlock";
    }

    private ResourceLocation toTableLoc(ResourceLocation in) {
        return new ResourceLocation(in.func_110624_b(), "blocks/" + in.func_110623_a());
    }

    @Override
    protected void registerTables() {
        this.registerHemp();
        this.register(IEBlocks.StoneDecoration.concreteSprayed, LootTable.func_216119_b());
        this.register(IEBlocks.WoodenDevices.windmill, LootTable.func_216119_b().func_216040_a(this.createPoolBuilder().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)IEBlocks.WoodenDevices.windmill).func_212841_b_((ILootFunction.IBuilder)new WindmillLootFunction.Builder()))));
        this.register(IEBlocks.WoodenDevices.crate, this.tileDrop());
        this.register(IEBlocks.WoodenDevices.reinforcedCrate, this.tileDrop());
        this.register(IEBlocks.StoneDecoration.coresample, this.tileDrop());
        this.register(IEBlocks.MetalDevices.toolbox, this.tileDrop());
        this.register(IEBlocks.Cloth.shaderBanner, this.tileDrop());
        this.register(IEBlocks.Cloth.shaderBannerWall, this.tileDrop());
        this.register(IEBlocks.Cloth.curtain, this.tileDrop());
        for (Block cap : new Block[]{IEBlocks.MetalDevices.capacitorLV, IEBlocks.MetalDevices.capacitorMV, IEBlocks.MetalDevices.capacitorHV, IEBlocks.MetalDevices.capacitorCreative}) {
            this.register(cap, this.tileDrop());
        }
        this.register(IEBlocks.Connectors.feedthrough, this.tileDrop());
        this.register(IEBlocks.MetalDevices.turretChem, this.tileDrop());
        this.register(IEBlocks.MetalDevices.turretGun, this.tileDrop(), this.dropInv());
        this.register(IEBlocks.WoodenDevices.woodenBarrel, this.tileDrop());
        this.register(IEBlocks.MetalDevices.barrel, this.tileDrop());
        this.registerMultiblocks();
        this.registerSelfDropping(IEBlocks.WoodenDevices.craftingTable, this.dropInv());
        this.registerSelfDropping(IEBlocks.WoodenDevices.workbench, this.dropInv());
        this.registerSelfDropping(IEBlocks.MetalDevices.cloche, this.dropInv());
        this.registerSelfDropping(IEBlocks.MetalDevices.chargingStation, this.dropInv());
        this.registerAllRemainingAsDefault();
    }

    private void registerMultiblocks() {
        this.registerMultiblock(IEBlocks.Multiblocks.cokeOven);
        this.registerMultiblock(IEBlocks.Multiblocks.blastFurnace);
        this.registerMultiblock(IEBlocks.Multiblocks.alloySmelter);
        this.registerMultiblock(IEBlocks.Multiblocks.blastFurnaceAdv);
        this.registerMultiblock(IEBlocks.Multiblocks.metalPress);
        this.registerMultiblock(IEBlocks.Multiblocks.crusher);
        this.registerMultiblock(IEBlocks.Multiblocks.tank);
        this.registerMultiblock(IEBlocks.Multiblocks.silo);
        this.registerMultiblock(IEBlocks.Multiblocks.assembler);
        this.registerMultiblock(IEBlocks.Multiblocks.autoWorkbench);
        this.registerMultiblock(IEBlocks.Multiblocks.bottlingMachine);
        this.registerMultiblock(IEBlocks.Multiblocks.squeezer);
        this.registerMultiblock(IEBlocks.Multiblocks.fermenter);
        this.registerMultiblock(IEBlocks.Multiblocks.refinery);
        this.registerMultiblock(IEBlocks.Multiblocks.dieselGenerator);
        this.registerMultiblock(IEBlocks.Multiblocks.excavator);
        this.registerMultiblock(IEBlocks.Multiblocks.bucketWheel);
        this.registerMultiblock(IEBlocks.Multiblocks.arcFurnace);
        this.registerMultiblock(IEBlocks.Multiblocks.lightningrod);
        this.registerMultiblock(IEBlocks.Multiblocks.mixer);
    }

    private void registerAllRemainingAsDefault() {
        for (Block b : IEContent.registeredIEBlocks) {
            if (this.tables.containsKey(this.toTableLoc(b.getRegistryName()))) continue;
            this.registerSelfDropping(b, new LootPool.Builder[0]);
        }
    }

    private void registerMultiblock(Block b) {
        this.register(b, this.dropInv(), this.dropOriginalBlock());
    }

    private LootPool.Builder dropInv() {
        return this.createPoolBuilder().func_216045_a(DropInventoryLootEntry.builder());
    }

    private LootPool.Builder tileDrop() {
        return this.createPoolBuilder().func_216045_a(TileDropLootEntry.builder());
    }

    private LootPool.Builder dropOriginalBlock() {
        return this.createPoolBuilder().func_216045_a(MBOriginalBlockLootEntry.builder());
    }

    private void register(Block b, LootPool.Builder ... pools) {
        LootTable.Builder builder = LootTable.func_216119_b();
        for (LootPool.Builder pool : pools) {
            builder.func_216040_a(pool);
        }
        this.register(b, builder);
    }

    private void register(Block b, LootTable.Builder table) {
        this.register(b.getRegistryName(), table);
    }

    private void register(ResourceLocation name, LootTable.Builder table) {
        if (this.tables.put(this.toTableLoc(name), table.func_216039_a(LootParameterSets.field_216267_h).func_216038_b()) != null) {
            throw new IllegalStateException("Duplicate loot table " + name);
        }
    }

    private void registerSelfDropping(Block b, LootPool.Builder ... pool) {
        LootPool.Builder[] withSelf = Arrays.copyOf(pool, pool.length + 1);
        withSelf[withSelf.length - 1] = this.singleItem((IItemProvider)b);
        this.register(b, withSelf);
    }

    private LootTable.Builder dropProvider(IItemProvider in) {
        return LootTable.func_216119_b().func_216040_a(this.singleItem(in));
    }

    private LootPool.Builder singleItem(IItemProvider in) {
        return this.createPoolBuilder().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)in));
    }

    private LootPool.Builder createPoolBuilder() {
        return LootPool.func_216096_a().func_212840_b_(SurvivesExplosion.func_215968_b());
    }

    private void registerHemp() {
        LootTable.Builder ret = LootTable.func_216119_b().func_216040_a(this.singleItem((IItemProvider)IEItems.Misc.hempSeeds));
        for (EnumHempGrowth g : EnumHempGrowth.values()) {
            if (g != HempBlock.getMaxGrowth(g)) continue;
            ret.func_216040_a(this.binBonusLootPool((IItemProvider)IEItems.Ingredients.hempFiber, Enchantments.field_185308_t, (float)g.ordinal() / 8.0f, 3).func_212840_b_(this.propertyIs(IEBlocks.Misc.hempPlant, (IProperty)HempBlock.GROWTH, (Comparable<T> & IStringSerializable)g)));
        }
        this.register(IEBlocks.Misc.hempPlant, ret);
    }

    private LootPool.Builder binBonusLootPool(IItemProvider item, Enchantment ench, float prob, int extra) {
        return this.createPoolBuilder().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)ench, (float)prob, (int)extra));
    }

    private <T extends Comparable<T> & IStringSerializable> ILootCondition.IBuilder propertyIs(Block b, IProperty<T> prop, T value) {
        return BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(prop, value));
    }
}

