/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeSerializer
extends IERecipeSerializer<RefineryRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.refinery);
    }

    @Override
    public RefineryRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidStack output = ApiUtils.jsonDeserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        FluidStack input0 = ApiUtils.jsonDeserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input0"));
        FluidStack input1 = ApiUtils.jsonDeserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"input1"));
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        return new RefineryRecipe(recipeId, output, input0, input1, energy);
    }

    @Nullable
    public RefineryRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidStack output = buffer.readFluidStack();
        FluidStack input0 = buffer.readFluidStack();
        FluidStack input1 = buffer.readFluidStack();
        int energy = buffer.readInt();
        return new RefineryRecipe(recipeId, output, input0, input1, energy);
    }

    public void write(PacketBuffer buffer, RefineryRecipe recipe) {
        buffer.writeFluidStack(recipe.output);
        buffer.writeFluidStack(recipe.input0);
        buffer.writeFluidStack(recipe.input1);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

