/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEConfig {
    public static final ForgeConfigSpec ALL;
    public static final Wires WIRES;
    public static final General GENERAL;
    public static final Machines MACHINES;
    public static final Ores ORES;
    public static final Tools TOOLS;
    public static final CachedConfigValues CACHED;

    private static <T> Predicate<Object> isSameSizeList(List<T> in) {
        return IEConfig.isSameSizeList(in, obj -> true);
    }

    private static <T> Predicate<Object> isSameSizeList(List<T> in, Predicate<T> elementChecker) {
        Preconditions.checkArgument((!in.isEmpty() ? 1 : 0) != 0);
        return obj -> {
            if (!(obj instanceof List) || ((List)obj).size() != in.size()) {
                return false;
            }
            Class<?> clazz = in.get(0).getClass();
            for (Object o : (List)obj) {
                if (clazz.isInstance(o) && elementChecker.test(o)) continue;
                return false;
            }
            return true;
        };
    }

    private static ForgeConfigSpec.IntValue addPositive(ForgeConfigSpec.Builder builder, String name, int defaultVal, String ... desc) {
        return builder.comment(desc).defineInRange(name, defaultVal, 1, Integer.MAX_VALUE);
    }

    private static double[] toDoubleArray(ForgeConfigSpec.ConfigValue<List<? extends Double>> in) {
        Double[] temp = ((List)in.get()).toArray(new Double[0]);
        double[] ret = new double[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            ret[i] = temp[i];
        }
        return ret;
    }

    private static int[] toIntArray(ForgeConfigSpec.ConfigValue<List<? extends Integer>> in) {
        Integer[] temp = ((List)in.get()).toArray(new Integer[0]);
        int[] ret = new int[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            ret[i] = temp[i];
        }
        return ret;
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading ev) {
        IEConfig.CACHED.wireLossRatio = IEConfig.toDoubleArray(IEConfig.WIRES.wireLossRatio);
        IEConfig.CACHED.wireTransferRate = IEConfig.toIntArray(IEConfig.WIRES.wireTransferRate);
        IEConfig.CACHED.blocksBreakWires = (Boolean)IEConfig.WIRES.blocksBreakWires.get();
        IEConfig.CACHED.wireDamage = (Boolean)IEConfig.WIRES.enableWireDamage.get();
        Level wireLoggerLevel = (Boolean)IEConfig.WIRES.enableWireLogger.get() != false ? Level.ALL : Level.WARN;
        Configurator.setLevel((String)WireLogger.logger.getName(), (Level)wireLoggerLevel);
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.Loading ev) {
        IEConfig.onConfigReload(null);
    }

    static {
        CACHED = new CachedConfigValues();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        WIRES = new Wires(builder);
        GENERAL = new General(builder);
        MACHINES = new Machines(builder);
        ORES = new Ores(builder);
        TOOLS = new Tools(builder);
        ALL = builder.build();
    }

    public static class CachedConfigValues {
        public double[] wireLossRatio;
        public int[] wireTransferRate;
        public boolean blocksBreakWires;
        public boolean wireDamage;
    }

    public static class Tools {
        public final ForgeConfigSpec.BooleanValue disableHammerCrushing;
        public final ForgeConfigSpec.IntValue hammerDurabiliy;
        public final ForgeConfigSpec.IntValue cutterDurabiliy;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Casull;
        public final ForgeConfigSpec.DoubleValue bulletDamage_AP;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Buck;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Dragon;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Homing;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Wolfpack;
        public final ForgeConfigSpec.DoubleValue bulletDamage_WolfpackPart;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Silver;
        public final ForgeConfigSpec.DoubleValue bulletDamage_Potion;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> earDefenders_SoundBlacklist;
        public final ForgeConfigSpec.IntValue chemthrower_consumption;
        public final ForgeConfigSpec.BooleanValue chemthrower_scroll;
        public final ForgeConfigSpec.IntValue railgun_consumption;
        public final ForgeConfigSpec.DoubleValue railgun_damage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> powerpack_whitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> powerpack_blacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolbox_tools;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolbox_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolbox_wiring;

        Tools(ForgeConfigSpec.Builder builder) {
            builder.push("tools");
            this.disableHammerCrushing = builder.comment("Set this to true to completely disable the ore-crushing recipes with the Engineers Hammer").define("disable_hammer_crushing", false);
            this.hammerDurabiliy = IEConfig.addPositive(builder, "hammer_durability", 100, new String[]{"The maximum durability of the Engineer's Hammer. Used up when hammering ingots into plates."});
            this.cutterDurabiliy = IEConfig.addPositive(builder, "cutter_durability", 250, new String[]{"The maximum durability of the Wirecutter. Used up when cutting plates into wire."});
            this.bulletDamage_Casull = this.addNonNegative(builder, "bulletDamage_casull", 10.0, "The amount of base damage a Casull Cartridge inflicts");
            this.bulletDamage_AP = this.addNonNegative(builder, "bulletDamage_ap", 10.0, "The amount of base damage a armor piercing Cartridge inflicts");
            this.bulletDamage_Buck = this.addNonNegative(builder, "bulletDamage_buck", 2.0, "The amount of base damage a single part of buckshot inflicts");
            this.bulletDamage_Dragon = this.addNonNegative(builder, "bulletDamage_dragon", 3.0, "The amount of base damage a dragon breath cartridge inflicts");
            this.bulletDamage_Homing = this.addNonNegative(builder, "bulletDamage_homing", 10.0, "The amount of base damage a homing cartridge inflicts");
            this.bulletDamage_Wolfpack = this.addNonNegative(builder, "bulletDamage_wolfpack", 6.0, "The amount of base damage a wolfpack cartridge inflicts");
            this.bulletDamage_WolfpackPart = this.addNonNegative(builder, "bulletDamage_wolfpack_part", 4.0, "The amount of base damage the sub-projectiles of a  wolfpack cartridge inflicts");
            this.bulletDamage_Silver = this.addNonNegative(builder, "bulletDamage_silver", 10.0, "The amount of damage a silver bullet inflicts");
            this.bulletDamage_Potion = this.addNonNegative(builder, "bulletDamage_phial", 1.0, "The amount of base damage a phial cartridge inflicts");
            this.earDefenders_SoundBlacklist = builder.comment("A list of sounds that should not be muffled by the Ear Defenders. Adding to this list requires knowledge of the correct sound resource names.").defineList("earDefenders_SoundBlacklist", (List)ImmutableList.of(), obj -> true);
            this.chemthrower_consumption = IEConfig.addPositive(builder, "chemthrower_consumption", 10, new String[]{"The mb of fluid the Chemical Thrower will consume per tick of usage"});
            this.chemthrower_scroll = builder.comment("Set this to false to disable the use of Sneak+Scroll to switch Chemthrower tanks.").define("chemthrower_scroll", true);
            this.railgun_consumption = IEConfig.addPositive(builder, "railgun_consumption", 800, new String[]{"The base amount of Flux consumed per shot by the Railgun"});
            this.railgun_damage = this.addNonNegative(builder, "railgun_damage_modifier", 1.0, "A modifier for the damage of all projectiles fired by the Railgun");
            this.powerpack_whitelist = builder.comment("A whitelist of armor pieces to allow attaching the capacitor backpack, formatting: [mod id]:[item name]").defineList("powerpack_whitelist", (List)ImmutableList.of(), obj -> true);
            this.powerpack_blacklist = builder.comment("A blacklist of armor pieces to allow attaching the capacitor backpack, formatting: [mod id]:[item name]. Whitelist has priority over this").defineList("powerpack_blacklist", (List)ImmutableList.of((Object)"embers:ashen_cloak_chest", (Object)"ic2:batpack", (Object)"ic2:cf_pack", (Object)"ic2:energy_pack", (Object)"ic2:jetpack", (Object)"ic2:jetpack_electric", (Object)"ic2:lappack"), obj -> true);
            this.toolbox_tools = builder.comment("A whitelist of tools allowed in the toolbox, formatting: [mod id]:[item name]").defineList("toolbox_tools", (List)ImmutableList.of(), obj -> true);
            this.toolbox_foods = builder.comment("A whitelist of foods allowed in the toolbox, formatting: [mod id]:[item name]").defineList("toolbox_foods", (List)ImmutableList.of(), obj -> true);
            this.toolbox_wiring = builder.comment("A whitelist of wire-related allowed in the toolbox, formatting: [mod id]:[item name]").defineList("toolbox_wiring", (List)ImmutableList.of(), obj -> true);
            builder.pop();
        }

        private ForgeConfigSpec.DoubleValue addNonNegative(ForgeConfigSpec.Builder builder, String name, double defaultVal, String ... desc) {
            return builder.comment(desc).defineInRange(name, defaultVal, 0.0, Double.MAX_VALUE);
        }
    }

    public static class Ores {
        public final OreConfig ore_copper;
        public final OreConfig ore_bauxite;
        public final OreConfig ore_lead;
        public final OreConfig ore_silver;
        public final OreConfig ore_nickel;
        public final OreConfig ore_uranium;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> oreDimBlacklist;
        public final ForgeConfigSpec.BooleanValue retrogen_log_flagChunk;
        public final ForgeConfigSpec.BooleanValue retrogen_log_remaining;
        public final ForgeConfigSpec.ConfigValue<String> retrogen_key;

        Ores(ForgeConfigSpec.Builder builder) {
            builder.push("ores");
            this.ore_copper = new OreConfig(builder, "copper", 8, 40, 72, 8);
            this.ore_bauxite = new OreConfig(builder, "bauxite", 4, 40, 85, 8);
            this.ore_lead = new OreConfig(builder, "lead", 6, 8, 36, 4);
            this.ore_silver = new OreConfig(builder, "silver", 8, 8, 40, 4);
            this.ore_nickel = new OreConfig(builder, "nickel", 6, 8, 24, 2);
            this.ore_uranium = new OreConfig(builder, "uranium", 4, 8, 24, 2);
            this.oreDimBlacklist = builder.comment("A blacklist of dimensions in which IE ores won't spawn. By default this is Nether and End").defineList("dimension_blocklist", (List)ImmutableList.of((Object)DimensionType.field_223228_b_.getRegistryName().toString(), (Object)DimensionType.field_223229_c_.getRegistryName().toString()), obj -> true);
            this.retrogen_key = builder.comment(new String[]{"The retrogeneration key. Basically IE checks if this key is saved in the chunks data. If it isn't, it will perform retrogen on all ores marked for retrogen.", "Change this in combination with the retrogen booleans to regen only some of the ores."}).define("retrogen_key", (Object)"DEFAULT");
            this.retrogen_log_flagChunk = builder.comment("Set this to false to disable the logging of the chunks that were flagged for retrogen.").define("retrogen_log_flagChunk", true);
            this.retrogen_log_remaining = builder.comment("Set this to false to disable the logging of the chunks that are still left to retrogen.").define("retrogen_log_remaining", true);
            builder.pop();
        }

        public static class OreConfig {
            public final ForgeConfigSpec.IntValue veinSize;
            public final ForgeConfigSpec.IntValue minY;
            public final ForgeConfigSpec.IntValue maxY;
            public final ForgeConfigSpec.IntValue veinsPerChunk;
            public final ForgeConfigSpec.BooleanValue retrogenEnabled;

            private OreConfig(ForgeConfigSpec.Builder builder, String name, int defSize, int defMinY, int defMaxY, int defNumPerChunk) {
                builder.comment("Ore generation config - " + name).push(name);
                this.veinSize = builder.comment("The maximum size of a vein. Set to 0 to disable generation").defineInRange("vein_size", defSize, 0, Integer.MAX_VALUE);
                this.minY = builder.comment("The minimum Y coordinate this ore can spawn at").defineInRange("min_y", defMinY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.maxY = builder.comment("The maximum Y coordinate this ore can spawn at").defineInRange("max_y", defMaxY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.veinsPerChunk = builder.comment("The average number of veins per chunk").defineInRange("avg_veins_per_chunk", defNumPerChunk, 0, Integer.MAX_VALUE);
                this.retrogenEnabled = builder.comment("Set this to true to allow retro-generation of " + name + " Ore.").define("retrogen_enable", false);
                builder.pop();
            }
        }
    }

    public static class Machines {
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> wireConnectorInput;
        public final ForgeConfigSpec.IntValue capacitorLvStorage;
        public final ForgeConfigSpec.IntValue capacitorLvInput;
        public final ForgeConfigSpec.IntValue capacitorLvOutput;
        public final ForgeConfigSpec.IntValue capacitorMvStorage;
        public final ForgeConfigSpec.IntValue capacitorMvInput;
        public final ForgeConfigSpec.IntValue capacitorMvOutput;
        public final ForgeConfigSpec.IntValue capacitorHvStorage;
        public final ForgeConfigSpec.IntValue capacitorHvInput;
        public final ForgeConfigSpec.IntValue capacitorHvOutput;
        public final ForgeConfigSpec.DoubleValue dynamo_output;
        public final ForgeConfigSpec.DoubleValue thermoelectric_output;
        public final ForgeConfigSpec.IntValue lightning_output;
        public final ForgeConfigSpec.IntValue dieselGen_output;
        public final ForgeConfigSpec.IntValue heater_consumption;
        public final ForgeConfigSpec.IntValue heater_speedupConsumption;
        public final ForgeConfigSpec.IntValue preheater_consumption;
        public final ForgeConfigSpec.IntValue coredrill_time;
        public final ForgeConfigSpec.IntValue coredrill_consumption;
        public final ForgeConfigSpec.IntValue pump_consumption;
        public final ForgeConfigSpec.IntValue pump_consumption_accelerate;
        public final ForgeConfigSpec.BooleanValue pump_infiniteWater;
        public final ForgeConfigSpec.BooleanValue pump_placeCobble;
        public final ForgeConfigSpec.IntValue charger_consumption;
        public final ForgeConfigSpec.IntValue teslacoil_consumption;
        public final ForgeConfigSpec.IntValue teslacoil_consumption_active;
        public final ForgeConfigSpec.DoubleValue teslacoil_damage;
        public final ForgeConfigSpec.IntValue turret_consumption;
        public final ForgeConfigSpec.IntValue turret_chem_consumption;
        public final ForgeConfigSpec.IntValue turret_gun_consumption;
        public final ForgeConfigSpec.IntValue cloche_consumption;
        public final ForgeConfigSpec.IntValue cloche_fertilizer;
        public final ForgeConfigSpec.IntValue cloche_fluid;
        public final ForgeConfigSpec.DoubleValue cloche_growth_mod;
        public final ForgeConfigSpec.DoubleValue cloche_solid_fertilizer_mod;
        public final ForgeConfigSpec.DoubleValue cloche_fluid_fertilizer_mod;
        public final ForgeConfigSpec.BooleanValue lantern_spawnPrevent;
        public final ForgeConfigSpec.IntValue lantern_energyDraw;
        public final ForgeConfigSpec.IntValue lantern_maximumStorage;
        public final ForgeConfigSpec.BooleanValue floodlight_spawnPrevent;
        public final ForgeConfigSpec.IntValue floodlight_energyDraw;
        public final ForgeConfigSpec.IntValue floodlight_maximumStorage;
        public final MachineRecipeConfig metalPressConfig;
        public final MachineRecipeConfig crusherConfig;
        public final MachineRecipeConfig squeezerConfig;
        public final MachineRecipeConfig fermenterConfig;
        public final MachineRecipeConfig refineryConfig;
        public final MachineRecipeConfig arcFurnaceConfig;
        public final ForgeConfigSpec.IntValue arcfurnace_electrodeDamage;
        public final ForgeConfigSpec.BooleanValue arcfurnace_electrodeCrafting;
        public final ForgeConfigSpec.BooleanValue arcfurnace_recycle;
        public final MachineRecipeConfig autoWorkbenchConfig;
        public final MachineRecipeConfig bottlingMachineConfig;
        public final MachineRecipeConfig mixerConfig;
        public final ForgeConfigSpec.IntValue assembler_consumption;
        public final ForgeConfigSpec.IntValue excavator_consumption;
        public final ForgeConfigSpec.DoubleValue excavator_speed;
        public final ForgeConfigSpec.BooleanValue excavator_particles;
        public final ForgeConfigSpec.DoubleValue excavator_chance;
        public final ForgeConfigSpec.DoubleValue excavator_fail_chance;
        public final ForgeConfigSpec.IntValue excavator_depletion;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excavator_dimBlacklist;

        Machines(ForgeConfigSpec.Builder builder) {
            builder.push("machines");
            ImmutableList defaultConnectorIO = ImmutableList.of((Object)256, (Object)1024, (Object)4096);
            this.wireConnectorInput = builder.comment("In- and output rates of LV,MV and HV Wire Conenctors. This is independant of the transferrate of the wires.").define("wireConnectorInput", (Object)defaultConnectorIO, IEConfig.isSameSizeList((List)defaultConnectorIO, i -> i >= 0));
            builder.push("capacitors");
            ForgeConfigSpec.IntValue[] temp = this.addCapacitorConfig(builder, "low", 100000, 256, 256);
            this.capacitorLvStorage = temp[0];
            this.capacitorLvInput = temp[1];
            this.capacitorLvOutput = temp[2];
            temp = this.addCapacitorConfig(builder, "medium", 1000000, 1024, 1024);
            this.capacitorMvStorage = temp[0];
            this.capacitorMvInput = temp[1];
            this.capacitorMvOutput = temp[2];
            temp = this.addCapacitorConfig(builder, "high", 4000000, 4096, 4096);
            this.capacitorHvStorage = temp[0];
            this.capacitorHvInput = temp[1];
            this.capacitorHvOutput = temp[2];
            builder.pop();
            this.dynamo_output = builder.comment("The base Flux that is output by the dynamo. This will be modified by the rotation modifier of the attached water- or windmill").defineInRange("dynamo_output", 3.0, 0.0, 2.147483647E9);
            this.thermoelectric_output = builder.comment("Output modifier for the energy created by the Thermoelectric Generator").defineInRange("thermoelectric_output", 1.0, 0.0, 2.147483647E9);
            this.lightning_output = builder.comment("The Flux that will be output by the lightning rod when it is struck").defineInRange("lightning_output", 16000000, 0, Integer.MAX_VALUE);
            this.dieselGen_output = builder.comment("The Flux per tick that the Diesel Generator will output. The burn time of the fuel determines the total output").defineInRange("dieselGen_output", 4096, 0, Integer.MAX_VALUE);
            this.heater_consumption = builder.comment("The Flux per tick consumed to add one heat to a furnace. Creates up to 4 heat in the startup time and then 1 heat per tick to keep it running").defineInRange("heater_consumption", 8, 1, Integer.MAX_VALUE);
            this.heater_speedupConsumption = builder.comment("The Flux per tick consumed to double the speed of the furnace. Only happens if furnace is at maximum heat.").defineInRange("heater_speedupConsumption", 24, 1, Integer.MAX_VALUE);
            this.preheater_consumption = IEConfig.addPositive(builder, "preheater_consumption", 32, new String[]{"The Flux per tick the Blast Furnace Preheater will consume to speed up the Blast Furnace"});
            this.coredrill_time = IEConfig.addPositive(builder, "coredrill_time", 200, new String[]{"The length in ticks it takes for the Core Sample Drill to figure out which mineral is found in a chunk"});
            this.coredrill_consumption = IEConfig.addPositive(builder, "coredrill_consumption", 40, new String[]{"The Flux per tick consumed by the Core Sample Drill"});
            this.pump_consumption = IEConfig.addPositive(builder, "pump_consumption", 250, new String[]{"The Flux the Fluid Pump will consume to pick up a fluid block in the world"});
            this.pump_consumption_accelerate = IEConfig.addPositive(builder, "pump_consumption_accelerate", 5, new String[]{"The Flux the Fluid Pump will consume pressurize and accelerate fluids, increasing the transferrate"});
            this.pump_infiniteWater = builder.comment("Set this to false to disable the fluid pump being able to draw infinite water from sources").define("pump_infiniteWater", true);
            this.pump_placeCobble = builder.comment("If this is set to true (default) the pump will replace fluids it picks up with cobblestone in order to reduce lag caused by flowing fluids.").define("pump_placeCobble", true);
            this.charger_consumption = IEConfig.addPositive(builder, "charger_consumption", 256, new String[]{"The Flux per tick the Charging Station can insert into an item"});
            this.teslacoil_consumption = IEConfig.addPositive(builder, "teslacoil_consumption", 256, new String[]{"The Flux per tick the Tesla Coil will consume, simply by being active"});
            this.teslacoil_consumption_active = IEConfig.addPositive(builder, "teslacoil_consumption_active", 512, new String[]{"The amount of Flux the Tesla Coil will consume when shocking an entity"});
            this.teslacoil_damage = builder.comment("The amount of damage the Tesla Coil will do when shocking an entity").defineInRange("teslacoil_damage", 6.0, 0.0, 2.147483647E9);
            this.turret_consumption = IEConfig.addPositive(builder, "turret_consumption", 64, new String[]{"The Flux per tick any turret consumes to monitor the area"});
            this.turret_chem_consumption = IEConfig.addPositive(builder, "turret_chem_consumption", 32, new String[]{"The Flux per tick the chemthrower turret consumes to shoot"});
            this.turret_gun_consumption = IEConfig.addPositive(builder, "turret_gun_consumption", 32, new String[]{"The Flux per tick the gun turret consumes to shoot"});
            this.cloche_consumption = IEConfig.addPositive(builder, "garden_cloche_consumption", 8, new String[]{"The Flux per tick the cloche consumes to grow plants"});
            this.cloche_fertilizer = IEConfig.addPositive(builder, "garden_cloche_fertilizer", 6000, new String[]{"The amount of ticks one dose of fertilizer lasts in the cloche"});
            this.cloche_fluid = IEConfig.addPositive(builder, "garden_cloche_fluid", 250, new String[]{"The amount of fluid the cloche uses per dose of fertilizer"});
            this.cloche_growth_mod = builder.comment("A modifier to apply to the cloches total growing speed").defineInRange("garden_cloche_growth_modifier", 1.0, 0.001, 1000.0);
            this.cloche_solid_fertilizer_mod = builder.comment("A base-modifier for all solid fertilizers in the cloche").defineInRange("garden_cloche_solid_fertilizer_mod", 1.0, 0.001, 1000.0);
            this.cloche_fluid_fertilizer_mod = builder.comment("A base-modifier for all fluid fertilizers in the cloche").defineInRange("garden_cloche_fluid_fertilizer_mod", 1.0, 0.001, 1000.0);
            this.lantern_spawnPrevent = builder.comment("Set this to false to disable the mob-spawn prevention of the Powered Lantern").worldRestart().define("lantern_SpawnPrevent", true);
            this.lantern_energyDraw = IEConfig.addPositive(builder, "lantern_energyDraw", 1, new String[]{"How much Flux the powered lantern draws per tick"});
            this.lantern_maximumStorage = IEConfig.addPositive(builder, "lantern_max_storage", 10, new String[]{"How much Flux the powered lantern can hold (should be greater than the power draw)"});
            this.floodlight_spawnPrevent = builder.comment("Set this to false to disable the mob-spawn prevention of the Floodlight").worldRestart().define("floodlight_spawnPrevent", true);
            this.floodlight_energyDraw = IEConfig.addPositive(builder, "floodlight_energyDraw", 5, new String[]{"How much Flux the floodlight draws per tick"});
            this.floodlight_maximumStorage = IEConfig.addPositive(builder, "floodlight_max_storage", 80, new String[]{"How much Flux the floodlight can hold (must be at least 10x the power draw)"});
            this.metalPressConfig = this.addMachineEnergyTimeModifiers(builder, "metal press");
            this.crusherConfig = this.addMachineEnergyTimeModifiers(builder, "crusher");
            this.squeezerConfig = this.addMachineEnergyTimeModifiers(builder, "squeezer");
            this.fermenterConfig = this.addMachineEnergyTimeModifiers(builder, "fermenter");
            this.refineryConfig = this.addMachineEnergyTimeModifiers(builder, "refinery");
            this.arcFurnaceConfig = this.addMachineEnergyTimeModifiers(builder, "arc furnace");
            this.autoWorkbenchConfig = this.addMachineEnergyTimeModifiers(builder, "auto workbench");
            this.bottlingMachineConfig = this.addMachineEnergyTimeModifiers(builder, "bottling machine");
            this.mixerConfig = this.addMachineEnergyTimeModifiers(builder, "mixer");
            this.arcfurnace_electrodeDamage = IEConfig.addPositive(builder, "arcfurnace_electrodeDamage", 96000, new String[]{"The maximum amount of damage Graphite Electrodes can take. While the furnace is working, electrodes sustain 1 damage per tick, so this is effectively the lifetime in ticks. The default value of 96000 makes them last for 8 consecutive ingame days"});
            this.arcfurnace_electrodeCrafting = builder.comment("Set this to true to make the blueprint for graphite electrodes craftable in addition to villager/dungeon loot").define("arcfurnace_electrodeCrafting", false);
            this.arcfurnace_recycle = builder.comment("Set this to false to disable the Arc Furnace's recycling of armors and tools").define("arcfurnace_recycle", true);
            this.assembler_consumption = IEConfig.addPositive(builder, "assembler_consumption", 80, new String[]{"The Flux the Assembler will consume to craft an item from a recipe"});
            this.excavator_consumption = IEConfig.addPositive(builder, "excavator_consumption", 4096, new String[]{"The Flux per tick the Excavator will consume to dig"});
            this.excavator_speed = builder.comment("The speed of the Excavator. Basically translates to how many degrees per tick it will turn.").defineInRange("excavator_speed", 1.0, 0.001, 1000.0);
            this.excavator_particles = builder.comment("Set this to false to disable the ridiculous amounts of particles the Excavator spawns").define("excavator_particles", true);
            this.excavator_chance = builder.comment("The chance that a given chunk will contain a mineral vein.").defineInRange("excavator_chance", 0.2, 0.001, 1.0);
            this.excavator_fail_chance = builder.comment("The chance that the Excavator will not dig up an ore with the currently downward-facing bucket.").defineInRange("excavator_fail_chance", 0.05, 0.0, 1.0);
            this.excavator_depletion = builder.comment("The maximum amount of yield one can get out of a chunk with the excavator. Set a number smaller than zero to make it infinite").defineInRange("excavator_depletion", 38400, -1, Integer.MAX_VALUE);
            this.excavator_dimBlacklist = builder.comment("List of dimensions that can't contain minerals. Default: The End.").defineList("excavator_dimBlacklist", (List)ImmutableList.of((Object)DimensionType.field_223229_c_.getRegistryName().toString()), obj -> true);
            builder.pop();
        }

        private MachineRecipeConfig addMachineEnergyTimeModifiers(ForgeConfigSpec.Builder builder, String machine) {
            String pathName = machine.toLowerCase(Locale.ENGLISH).replace(' ', '_');
            ForgeConfigSpec.DoubleValue energy = builder.comment("A modifier to apply to the energy costs of every " + machine + " recipe").defineInRange(pathName + "_energyModifier", 1.0, 0.001, 1000.0);
            ForgeConfigSpec.DoubleValue time = builder.comment("A modifier to apply to the time of every " + machine + " recipe").defineInRange(pathName + "_timeModifier", 1.0, 0.001, 1000.0);
            return new MachineRecipeConfig(energy, time);
        }

        private ForgeConfigSpec.IntValue[] addCapacitorConfig(ForgeConfigSpec.Builder builder, String voltage, int defaultStorage, int defaultInput, int defaultOutput) {
            ForgeConfigSpec.IntValue[] ret = new ForgeConfigSpec.IntValue[3];
            builder.comment("Configuration for the " + voltage + " voltage capacitor").push(voltage.charAt(0) + "v");
            String prefix = "capacitor" + Character.toUpperCase(voltage.charAt(0)) + "V_";
            ret[0] = builder.comment("Maximum energy stored (Flux)").defineInRange(prefix + "storage", defaultStorage, 1, Integer.MAX_VALUE);
            ret[1] = builder.comment("Maximum energy input (Flux/tick)").defineInRange(prefix + "input", defaultInput, 1, Integer.MAX_VALUE);
            ret[2] = builder.comment("Maximum energy output (Flux/tick)").defineInRange(prefix + "output", defaultOutput, 1, Integer.MAX_VALUE);
            builder.pop();
            return ret;
        }

        public static class MachineRecipeConfig {
            public final ForgeConfigSpec.DoubleValue energyModifier;
            public final ForgeConfigSpec.DoubleValue timeModifier;

            public MachineRecipeConfig(ForgeConfigSpec.DoubleValue energyModifier, ForgeConfigSpec.DoubleValue timeModifier) {
                this.energyModifier = energyModifier;
                this.timeModifier = timeModifier;
            }
        }
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue disableFancyTESR;
        public final ForgeConfigSpec.BooleanValue showTextOverlay;
        public final ForgeConfigSpec.BooleanValue nixietubeFont;
        public final ForgeConfigSpec.BooleanValue adjustManualScale;
        public final ForgeConfigSpec.BooleanValue badEyesight;
        public final ForgeConfigSpec.BooleanValue tagTooltips;
        public final ForgeConfigSpec.DoubleValue increasedTileRenderdistance;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> preferredOres;
        public final ForgeConfigSpec.BooleanValue showUpdateNews;
        public final ForgeConfigSpec.BooleanValue villagerHouse;
        public final ForgeConfigSpec.BooleanValue enableVillagers;
        public final ForgeConfigSpec.IntValue hempSeedWeight;
        public final ForgeConfigSpec.BooleanValue fancyItemHolding;
        public final ForgeConfigSpec.BooleanValue stencilBufferEnabled;
        public final Map<String, ForgeConfigSpec.BooleanValue> compat = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        public final ForgeConfigSpec.BooleanValue enableDebug;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.disableFancyTESR = builder.comment(new String[]{"Disables most lighting code for certain models that are rendered dynamically (TESR). May improve FPS.", "Affects turrets and garden cloches"}).define("disableFancyTESR", false);
            this.showTextOverlay = builder.comment("Show the text overlay for various blocks, such as the configuration of capacitors or pumps").define("showTextOverlay", true);
            this.nixietubeFont = builder.comment("Set this to false to disable the super awesome looking nixie tube front for the voltmeter and other things").define("nixietubeFont", true);
            this.adjustManualScale = builder.comment("Set this to false to disable the manual's forced change of GUI scale").define("adjustManualScale", false);
            this.badEyesight = builder.comment(new String[]{"Set this to true if you suffer from bad eyesight. The Engineer's manual will be switched to a bold and darker text to improve readability.", "Note that this may lead to a break of formatting and have text go off the page in some instances. This is unavoidable."}).define("badEyesight", false);
            this.tagTooltips = builder.comment("Controls if item tooltips should contain the tags names of items. These tooltips are only visible in advanced tooltip mode (F3+H)").define("tagTooltips", true);
            this.increasedTileRenderdistance = builder.comment("Increase the distance at which certain TileEntities (specifically windmills) are still visible. This is a modifier, so set it to 1 for default render distance, to 2 for doubled distance and so on.").defineInRange("increasedTileRenderdistance", 1.5, 0.0, Double.MAX_VALUE);
            this.preferredOres = builder.comment(new String[]{"A list of preferred Mod IDs that results of IE processes should stem from, aka which mod you want the copper to come from.", "This affects the ores dug by the excavator, as well as those crushing recipes that don't have associated IE items. This list is in oreder of priority."}).defineList("preferredOres", (List)ImmutableList.of((Object)"immersiveengineering"), obj -> true);
            this.showUpdateNews = builder.comment("Set this to false to hide the update news in the manual").define("showUpdateNews", true);
            this.villagerHouse = builder.comment("Set this to false to stop the IE villager house from spawning").worldRestart().define("villagerHouse", true);
            this.enableVillagers = builder.comment("Set this to false to remove IE villagers from the game").define("enableVillagers", true);
            this.hempSeedWeight = builder.comment("The weight that hempseeds have when breaking tall grass. 5 by default, set to 0 to disable drops").defineInRange("hempSeedWeight", 5, 0, Integer.MAX_VALUE);
            this.fancyItemHolding = builder.comment("Allows revolvers and other IE items to look properly held in 3rd person. This uses a coremod. Can be disabled in case of conflicts with other animation mods.").define("fancyItemHolding", true);
            this.stencilBufferEnabled = builder.comment("Set to false to disable the stencil buffer. This may be necessary on older GPUs.").define("stencilBufferEnabled", true);
            builder.comment(new String[]{"A list of all mods that IE has integrated compatability for", "Setting any of these to false disables the respective compat"}).push("compat");
            for (String mod : IECompatModule.moduleClasses.keySet()) {
                this.compat.put(mod, builder.define(mod, true));
            }
            builder.pop();
            this.enableDebug = builder.comment("A config setting to enable debug features. These features may vary between releases, may cause crashes, and are unsupported. Do not enable unless asked to by a developer of IE.").define("enableDebug", false);
            builder.pop();
        }
    }

    public static class Wires {
        public final ForgeConfigSpec.BooleanValue sanitizeConnections;
        public final ForgeConfigSpec.BooleanValue enableWireLogger;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> wireTransferRate;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> wireLossRatio;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> wireColouration;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> wireLength;
        public final ForgeConfigSpec.BooleanValue enableWireDamage;
        public final ForgeConfigSpec.BooleanValue blocksBreakWires;

        Wires(ForgeConfigSpec.Builder builder) {
            builder.comment("Configuration related to Immersive Engineering wires").push("wires");
            this.sanitizeConnections = builder.comment(new String[]{"Attempts to make the internal data structures used for wires consistent with the connectors in the world.Use with care and backups and only when suspecting corrupted data.", "This option will check and load all connection endpoints and may slow down the world loading process."}).define("sanitizeConnections", false);
            this.enableWireLogger = builder.comment("Enable detailed logging for the wire network. This can be useful for developers to track down issues related to wires.").define("enableWireLogger", false);
            ArrayList defaultTransferRates = Lists.newArrayList((Object[])new Integer[]{2048, 8192, 32768, 0, 0, 0});
            this.wireTransferRate = builder.comment("The transfer rates in Flux/t for the wire tiers (copper, electrum, HV, Structural Rope, Cable & Redstone (no transfer) )").define("wireTransferRate", (Object)defaultTransferRates, IEConfig.isSameSizeList(defaultTransferRates, i -> i >= 0));
            ArrayList defaultLossRates = Lists.newArrayList((Object[])new Double[]{0.05, 0.025, 0.025, 1.0, 1.0, 1.0});
            this.wireLossRatio = builder.comment("The percentage of power lost every 16 blocks of distance for the wire tiers (copper, electrum, HV, Structural Rope, Cable & Redstone(no transfer) )").define("wireLossRatio", (Object)defaultLossRates, IEConfig.isSameSizeList(defaultLossRates, d -> d >= 0.0));
            ArrayList defaultColours = Lists.newArrayList((Object[])new Integer[]{11758655, 15573061, 0x6F6F6F, 9862765, 0x6F6F6F, 0xFF2F2F, 16445918, 10323322});
            this.wireColouration = builder.comment("The RGB colourate of the wires.").define("wireColouration", (Object)defaultColours, IEConfig.isSameSizeList(defaultColours));
            ArrayList defaultLength = Lists.newArrayList((Object[])new Integer[]{16, 16, 32, 32, 32, 32});
            this.wireLength = builder.comment("\"The maximum length wire can have. Copper and Electrum should be similar, Steel is meant for long range transport, Structural Rope & Cables are purely decorational\"").define("wireLength", (Object)defaultLength, IEConfig.isSameSizeList(defaultLength, i -> i > 0));
            this.enableWireDamage = builder.comment(new String[]{"If this is enabled, wires connected to power sources will cause damage to entities touching them", "This shouldn't cause significant lag but possibly will. If it does, please report it at https://github.com/BluSunrize/ImmersiveEngineering/issues unless there is a report of it already."}).define("enableWireDamage", true);
            this.blocksBreakWires = builder.comment("If this is enabled, placing a block in a wire will break it (drop the wire coil)").define("blocksBreakWires", true);
            builder.pop();
        }
    }
}

