/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class ModelCoresample
extends BakedIEModel {
    private static final Cache<String, ModelCoresample> modelCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private ExcavatorHandler.MineralMix mineral;
    private final VertexFormat format;
    private List<BakedQuad> bakedQuads;
    ItemOverrideList overrideList = new ItemOverrideList(){

        @Nullable
        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            String name;
            if (ItemNBTHelper.hasKey(stack, "mineral") && !(name = ItemNBTHelper.getString(stack, "mineral")).isEmpty()) {
                try {
                    return (IBakedModel)modelCache.get((Object)name, () -> {
                        VertexFormat format = originalModel instanceof ModelCoresample ? ((ModelCoresample)originalModel).format : DefaultVertexFormats.field_176600_a;
                        for (ExcavatorHandler.MineralMix mix : ExcavatorHandler.mineralList.values()) {
                            if (!name.equals(mix.func_199560_c().toString())) continue;
                            return new ModelCoresample(mix, format);
                        }
                        throw new RuntimeException("Invalid mineral mix: " + name);
                    });
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            return originalModel;
        }
    };
    static HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap = new HashMap();

    public ModelCoresample(ExcavatorHandler.MineralMix mineral, VertexFormat format) {
        this.mineral = mineral;
        this.format = format;
    }

    public static void clearCache() {
        modelCache.invalidateAll();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState coreState, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ExcavatorHandler.MineralMix mineral = extraData.hasProperty(IEProperties.Model.MINERAL) ? (ExcavatorHandler.MineralMix)extraData.getData(IEProperties.Model.MINERAL) : this.mineral;
        if (this.bakedQuads == null || this.mineral == null) {
            this.bakedQuads = new ArrayList<BakedQuad>();
            Exception cause = null;
            try {
                TextureAtlasSprite textureStone;
                int weight;
                float width = 0.25f;
                float depth = 0.25f;
                float wOff = (1.0f - width) / 2.0f;
                float dOff = (1.0f - depth) / 2.0f;
                int pixelLength = 0;
                HashMap<TextureAtlasSprite, Integer> textureOre = new HashMap<TextureAtlasSprite, Integer>();
                if (mineral != null) {
                    for (StackWithChance o : mineral.outputs) {
                        if (o.getStack().func_190926_b()) continue;
                        weight = Math.max(2, Math.round(16.0f * o.getChance()));
                        Block b = Block.func_149634_a((Item)o.getStack().func_77973_b());
                        if (b == Blocks.field_150350_a) {
                            b = mineral.background;
                        }
                        BlockState state = b.func_176223_P();
                        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                        textureOre.put(model.func_177554_e(), weight);
                        pixelLength += weight;
                    }
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(mineral.background.func_176223_P());
                    textureStone = model.func_177554_e();
                } else {
                    pixelLength = 16;
                    textureStone = ClientUtils.getSprite(new ResourceLocation("block/stone"));
                }
                double[] stoneUVs = new double[]{16.0f * wOff, 16.0f * dOff, 16.0f * (wOff + width), 16.0f * (dOff + depth)};
                this.putVertexData(new Vec3d(0.0, -1.0, 0.0), new Vec3d[]{new Vec3d((double)wOff, 0.0, (double)dOff), new Vec3d((double)(wOff + width), 0.0, (double)dOff), new Vec3d((double)(wOff + width), 0.0, (double)(dOff + depth)), new Vec3d((double)wOff, 0.0, (double)(dOff + depth))}, stoneUVs, textureStone, this.bakedQuads);
                this.putVertexData(new Vec3d(0.0, 1.0, 0.0), new Vec3d[]{new Vec3d((double)wOff, 1.0, (double)dOff), new Vec3d((double)wOff, 1.0, (double)(dOff + depth)), new Vec3d((double)(wOff + width), 1.0, (double)(dOff + depth)), new Vec3d((double)(wOff + width), 1.0, (double)dOff)}, stoneUVs, textureStone, this.bakedQuads);
                if (textureOre.isEmpty()) {
                    double[][] uvs = new double[4][];
                    for (int j = 0; j < 4; ++j) {
                        uvs[j] = new double[]{j * 4, 0.0, (j + 1) * 4, 16.0};
                    }
                    this.putVertexData(new Vec3d(0.0, 0.0, -1.0), new Vec3d[]{new Vec3d((double)wOff, 0.0, (double)dOff), new Vec3d((double)wOff, 1.0, (double)dOff), new Vec3d((double)(wOff + width), 1.0, (double)dOff), new Vec3d((double)(wOff + width), 0.0, (double)dOff)}, uvs[0], textureStone, this.bakedQuads);
                    this.putVertexData(new Vec3d(0.0, 0.0, 1.0), new Vec3d[]{new Vec3d((double)(wOff + width), 0.0, (double)(dOff + depth)), new Vec3d((double)(wOff + width), 1.0, (double)(dOff + depth)), new Vec3d((double)wOff, 1.0, (double)(dOff + depth)), new Vec3d((double)wOff, 0.0, (double)(dOff + depth))}, uvs[2], textureStone, this.bakedQuads);
                    this.putVertexData(new Vec3d(-1.0, 0.0, 0.0), new Vec3d[]{new Vec3d((double)wOff, 0.0, (double)(dOff + depth)), new Vec3d((double)wOff, 1.0, (double)(dOff + depth)), new Vec3d((double)wOff, 1.0, (double)dOff), new Vec3d((double)wOff, 0.0, (double)dOff)}, uvs[3], textureStone, this.bakedQuads);
                    this.putVertexData(new Vec3d(1.0, 0.0, 0.0), new Vec3d[]{new Vec3d((double)(wOff + width), 0.0, (double)dOff), new Vec3d((double)(wOff + width), 1.0, (double)dOff), new Vec3d((double)(wOff + width), 1.0, (double)(dOff + depth)), new Vec3d((double)(wOff + width), 0.0, (double)(dOff + depth))}, uvs[1], textureStone, this.bakedQuads);
                } else {
                    float h = 0.0f;
                    for (TextureAtlasSprite sprite : textureOre.keySet()) {
                        weight = (Integer)textureOre.get(sprite);
                        int v = weight > 8 ? 16 - weight : 8;
                        double[][] uvs = new double[4][];
                        for (int j = 0; j < 4; ++j) {
                            uvs[j] = new double[]{j * 4, v, (j + 1) * 4, v + weight};
                        }
                        float h1 = (float)weight / (float)pixelLength;
                        this.putVertexData(new Vec3d(0.0, 0.0, -1.0), new Vec3d[]{new Vec3d((double)wOff, (double)h, (double)dOff), new Vec3d((double)wOff, (double)(h + h1), (double)dOff), new Vec3d((double)(wOff + width), (double)(h + h1), (double)dOff), new Vec3d((double)(wOff + width), (double)h, (double)dOff)}, uvs[0], sprite, this.bakedQuads);
                        this.putVertexData(new Vec3d(0.0, 0.0, 1.0), new Vec3d[]{new Vec3d((double)(wOff + width), (double)h, (double)(dOff + depth)), new Vec3d((double)(wOff + width), (double)(h + h1), (double)(dOff + depth)), new Vec3d((double)wOff, (double)(h + h1), (double)(dOff + depth)), new Vec3d((double)wOff, (double)h, (double)(dOff + depth))}, uvs[2], sprite, this.bakedQuads);
                        this.putVertexData(new Vec3d(-1.0, 0.0, 0.0), new Vec3d[]{new Vec3d((double)wOff, (double)h, (double)(dOff + depth)), new Vec3d((double)wOff, (double)(h + h1), (double)(dOff + depth)), new Vec3d((double)wOff, (double)(h + h1), (double)dOff), new Vec3d((double)wOff, (double)h, (double)dOff)}, uvs[3], sprite, this.bakedQuads);
                        this.putVertexData(new Vec3d(1.0, 0.0, 0.0), new Vec3d[]{new Vec3d((double)(wOff + width), (double)h, (double)dOff), new Vec3d((double)(wOff + width), (double)(h + h1), (double)dOff), new Vec3d((double)(wOff + width), (double)(h + h1), (double)(dOff + depth)), new Vec3d((double)(wOff + width), (double)h, (double)(dOff + depth))}, uvs[1], sprite, this.bakedQuads);
                        h += h1;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                cause = e;
            }
            if (this.bakedQuads.isEmpty()) {
                if (cause != null) {
                    throw new RuntimeException("Empty quad list!", cause);
                }
                throw new RuntimeException("Empty quad list!");
            }
            return this.bakedQuads;
        }
        return this.bakedQuads;
    }

    protected final void putVertexData(Vec3d normal, Vec3d[] vertices, double[] uvs, TextureAtlasSprite sprite, List<BakedQuad> out) {
        float d = LightUtil.diffuseLight((float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c));
        BakedQuad quad = ClientUtils.createBakedQuad(this.format, vertices, Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c), sprite, uvs, new float[]{d, d, d, 1.0f}, false);
        out.add(quad);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this;
    }

    @Override
    public boolean func_230044_c_() {
        return false;
    }

    static {
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.28, 0.0).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.28, 0.0).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.625, 0.625, 0.625).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.625, 0.625, 0.625).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.GUI, new Matrix4().scale(1.25, 1.25, 1.25).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(20.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-30.0), 0.0, 0.0, 1.0));
        transformationMap.put(ItemCameraTransforms.TransformType.FIXED, new Matrix4().scale(1.5, 1.5, 1.5).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0));
        transformationMap.put(ItemCameraTransforms.TransformType.GROUND, new Matrix4().scale(1.5, 1.5, 1.5).rotate(Math.toRadians(180.0), 1.0, 0.0, 0.0));
    }

    public static class CoresampleLoader
    implements IModelLoader<RawCoresampleModel> {
        public static final ResourceLocation LOCATION = new ResourceLocation("immersiveengineering", "models/coresample");

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public RawCoresampleModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new RawCoresampleModel();
        }
    }

    public static class RawCoresampleModel
    implements IModelGeometry<RawCoresampleModel> {
        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new ModelCoresample(null, DefaultVertexFormats.field_176600_a);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ImmutableList.of();
        }
    }
}

