/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class IICProxy
implements IImmersiveConnectable {
    private DimensionType dim;
    private BlockPos pos;
    private List<Connection> internalConns;
    private List<ConnectionPoint> points;

    public IICProxy(DimensionType dimension, BlockPos pos, Collection<Connection> internal, Collection<ConnectionPoint> points) {
        this.dim = dimension;
        this.pos = pos;
        this.internalConns = new ArrayList<Connection>(internal);
        this.points = new ArrayList<ConnectionPoint>(points);
    }

    public IICProxy(DimensionType dimension, BlockPos pos) {
        this(dimension, pos, (Collection<Connection>)ImmutableList.of(), (Collection<ConnectionPoint>)ImmutableList.of());
    }

    public IICProxy(TileEntity te) {
        if (!(te instanceof IImmersiveConnectable)) {
            throw new IllegalArgumentException("Can't create an IICProxy for a null/non-IIC TileEntity");
        }
        this.dim = te.func_145831_w().func_201675_m().func_186058_p();
        this.pos = Utils.toCC(te);
        this.internalConns = Lists.newArrayList(((IImmersiveConnectable)te).getInternalConnections());
        this.points = new ArrayList<ConnectionPoint>(((IImmersiveConnectable)te).getConnectionPoints());
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return this.internalConns;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public DimensionType getDimension() {
        return this.dim;
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        ServerWorld w = DimensionManager.getWorld((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (DimensionType)this.dim, (boolean)false, (boolean)true);
        if (w == null) {
            WireLogger.logger.warn("Tried to remove a wire in dimension " + this.dim + " which does not exist");
            return;
        }
        TileEntity te = w.func_175625_s(this.pos);
        if (!(te instanceof IImmersiveConnectable)) {
            return;
        }
        ((IImmersiveConnectable)te).removeCable(connection, attachedPoint);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return null;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
    }

    @Override
    public Vec3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        return null;
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return this.points;
    }

    public static IICProxy readFromNBT(CompoundNBT nbt) {
        ListNBT internalNBT = nbt.func_150295_c("internal", 10);
        ArrayList<Connection> internal = new ArrayList<Connection>(internalNBT.size());
        for (INBT c : internalNBT) {
            internal.add(new Connection((CompoundNBT)c));
        }
        ListNBT pointNBT = nbt.func_150295_c("points", 10);
        ArrayList<ConnectionPoint> points = new ArrayList<ConnectionPoint>();
        for (INBT c : pointNBT) {
            points.add(new ConnectionPoint((CompoundNBT)c));
        }
        return new IICProxy(DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))), NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos")), internal, points);
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT ret = new CompoundNBT();
        ret.func_74778_a("dim", this.dim.getRegistryName().toString());
        ret.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        ListNBT points = new ListNBT();
        for (ConnectionPoint cp : this.points) {
            points.add((Object)cp.createTag());
        }
        ret.func_218657_a("points", (INBT)points);
        ListNBT internal = new ListNBT();
        for (Connection conn : this.internalConns) {
            internal.add((Object)conn.toNBT());
        }
        ret.func_218657_a("internal", (INBT)internal);
        return ret;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.pos;
    }
}

