/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.common.items.IEItems;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class BulletHandler {
    public static ItemStack emptyCasing = ItemStack.field_190927_a;
    public static ItemStack emptyShell = ItemStack.field_190927_a;
    private static final BiMap<ResourceLocation, IBullet> REGISTRY = HashBiMap.create();

    public static void registerBullet(ResourceLocation name, IBullet bullet) {
        Preconditions.checkState((!REGISTRY.containsKey((Object)name) ? 1 : 0) != 0, (Object)(name + " is already registered"));
        Preconditions.checkState((!REGISTRY.containsValue((Object)bullet) ? 1 : 0) != 0);
        REGISTRY.put((Object)name, (Object)bullet);
    }

    public static IBullet getBullet(ResourceLocation name) {
        return (IBullet)REGISTRY.get((Object)name);
    }

    public static ResourceLocation findRegistryName(IBullet bullet) {
        if (bullet != null) {
            return (ResourceLocation)REGISTRY.inverse().get((Object)bullet);
        }
        return null;
    }

    public static ItemStack getBulletStack(ResourceLocation key) {
        return new ItemStack((IItemProvider)BulletHandler.getBulletItem(key));
    }

    public static Item getBulletItem(ResourceLocation key) {
        return IEItems.Weapons.bullets.get(BulletHandler.getBullet(key));
    }

    public static Collection<ResourceLocation> getAllKeys() {
        return REGISTRY.keySet();
    }

    public static Collection<IBullet> getAllValues() {
        return REGISTRY.values();
    }

    public static class DamagingBullet
    implements IBullet {
        final DamageSourceProvider damageSourceGetter;
        final float damage;
        boolean resetHurt = false;
        boolean setFire = false;
        Supplier<ItemStack> casing;
        ResourceLocation[] textures;

        public DamagingBullet(DamageSourceProvider damageSourceGetter, float damage, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this(damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(DamageSourceProvider damageSourceGetter, float damage, boolean resetHurt, boolean setFire, Supplier<ItemStack> casing, ResourceLocation ... textures) {
            this.damageSourceGetter = damageSourceGetter;
            this.damage = damage;
            this.resetHurt = resetHurt;
            this.setFire = setFire;
            this.casing = casing;
            this.textures = textures;
        }

        float getDamage(boolean headshot) {
            return this.damage * (headshot ? 1.5f : 1.0f);
        }

        @Override
        public void onHitTarget(World world, RayTraceResult rtr, @Nullable UUID shooterUUID, Entity projectile, boolean headshot) {
            if (!(rtr instanceof EntityRayTraceResult)) {
                return;
            }
            EntityRayTraceResult target = (EntityRayTraceResult)rtr;
            Entity hitEntity = target.func_216348_a();
            if (!world.field_72995_K && hitEntity != null && this.damageSourceGetter != null) {
                PlayerEntity shooter = null;
                if (shooterUUID != null) {
                    shooter = world.func_217371_b(shooterUUID);
                }
                if (hitEntity.func_70097_a(this.damageSourceGetter.getSource(projectile, (Entity)shooter, hitEntity), this.getDamage(headshot))) {
                    if (this.resetHurt) {
                        hitEntity.field_70172_ad = 0;
                    }
                    if (this.setFire) {
                        hitEntity.func_70015_d(3);
                    }
                }
            }
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return (ItemStack)this.casing.get();
        }

        @Override
        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }

        public static interface DamageSourceProvider {
            public DamageSource getSource(Entity var1, Entity var2, Entity var3);
        }
    }

    public static interface IBullet {
        default public boolean isProperCartridge() {
            return true;
        }

        default public String getTranslationKey(ItemStack cartridge, String baseName) {
            return baseName;
        }

        default public void addTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        }

        default public int getProjectileCount(@Nullable PlayerEntity shooter) {
            return 1;
        }

        default public Entity getProjectile(@Nullable PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean charged) {
            return projectile;
        }

        public void onHitTarget(World var1, RayTraceResult var2, @Nullable UUID var3, Entity var4, boolean var5);

        public ItemStack getCasing(ItemStack var1);

        public ResourceLocation[] getTextures();

        public int getColour(ItemStack var1, int var2);

        default public boolean isValidForTurret() {
            return false;
        }

        default public SoundEvent getSound() {
            return null;
        }
    }
}

