/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.crafting.IngredientWithSizeSerializer;
import com.google.gson.JsonElement;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;

public class IngredientWithSize
implements Predicate<ItemStack> {
    protected final Ingredient basePredicate;
    protected final int count;

    public IngredientWithSize(Ingredient basePredicate, int count) {
        this.basePredicate = basePredicate;
        this.count = count;
    }

    public IngredientWithSize(Ingredient basePredicate) {
        this(basePredicate, 1);
    }

    public IngredientWithSize(Tag<Item> basePredicate, int count) {
        this(Ingredient.func_199805_a(basePredicate), count);
    }

    public IngredientWithSize(Tag<Item> basePredicate) {
        this(basePredicate, 1);
    }

    public static IngredientWithSize deserialize(JsonElement input) {
        return IngredientWithSizeSerializer.INSTANCE.parse(input);
    }

    public static IngredientWithSize read(PacketBuffer input) {
        return IngredientWithSizeSerializer.INSTANCE.parse(input);
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.basePredicate.test(itemStack) && itemStack.func_190916_E() >= this.count;
    }

    @Nonnull
    public ItemStack[] getMatchingStacks() {
        ItemStack[] baseStacks = this.basePredicate.func_193365_a();
        ItemStack[] ret = new ItemStack[baseStacks.length];
        for (int i = 0; i < baseStacks.length; ++i) {
            ret[i] = ApiUtils.copyStackWithAmount(baseStacks[i], this.count);
        }
        return ret;
    }

    @Nonnull
    public JsonElement serialize() {
        return IngredientWithSizeSerializer.INSTANCE.write(this);
    }

    public boolean hasNoMatchingItems() {
        return this.basePredicate.func_203189_d();
    }

    public int getCount() {
        return this.count;
    }

    public Ingredient getBaseIngredient() {
        return this.basePredicate;
    }

    public IngredientWithSize withSize(int size) {
        return new IngredientWithSize(this.basePredicate, size);
    }

    public static IngredientWithSize of(ItemStack stack) {
        return new IngredientWithSize(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), stack.func_190916_E());
    }

    public ItemStack getRandomizedExampleStack(int rand) {
        ItemStack[] all = this.getMatchingStacks();
        return all[rand / 20 % all.length];
    }

    public boolean testIgnoringSize(ItemStack itemstack) {
        return this.basePredicate.test(itemstack);
    }

    public void write(PacketBuffer out) {
        IngredientWithSizeSerializer.INSTANCE.write(out, this);
    }
}

