/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilitySkyhookData {
    @CapabilityInject(value=SkyhookUserData.class)
    public static Capability<SkyhookUserData> SKYHOOK_USER_DATA = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(SkyhookUserData.class, (Capability.IStorage)new Capability.IStorage<SkyhookUserData>(){

            public INBT writeNBT(Capability<SkyhookUserData> capability, SkyhookUserData instance, Direction side) {
                return IntNBT.func_229692_a_((int)instance.status.ordinal());
            }

            public void readNBT(Capability<SkyhookUserData> capability, SkyhookUserData instance, Direction side, INBT nbt) {
                instance.status = SkyhookStatus.values()[((IntNBT)nbt).func_150287_d()];
            }
        }, SkyhookUserData::new);
    }

    public static enum SkyhookStatus {
        NONE(null, null),
        RIDING(NONE, null),
        HOLDING_CONNECTING(null, NONE),
        HOLDING_FAILED(null, NONE),
        HOLDING_RIDING(HOLDING_FAILED, RIDING);

        @Nullable
        public final SkyhookStatus dismount;
        @Nullable
        public final SkyhookStatus release;
        @Nullable
        public SkyhookStatus mount;

        private SkyhookStatus(SkyhookStatus dismount, SkyhookStatus release) {
            this.dismount = dismount;
            this.release = release;
        }

        static {
            SkyhookStatus.NONE.mount = RIDING;
            SkyhookStatus.HOLDING_CONNECTING.mount = HOLDING_RIDING;
        }
    }

    public static class SimpleSkyhookProvider
    implements ICapabilityProvider {
        SkyhookUserData data = new SkyhookUserData();
        LazyOptional<SkyhookUserData> opt = ApiUtils.constantOptional(this.data);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == SKYHOOK_USER_DATA) {
                return this.opt.cast();
            }
            return LazyOptional.empty();
        }
    }

    public static class SkyhookUserData {
        private SkyhookStatus status = SkyhookStatus.NONE;
        @Nullable
        public SkylineHookEntity hook = null;

        public void release() {
            if (this.status.release != null) {
                this.status = this.status.release;
            }
        }

        public void dismount() {
            if (this.hook != null) {
                IELogger.logger.debug("Dismounting");
                this.hook.func_70106_y();
                this.hook = null;
            }
            if (this.status.dismount != null) {
                this.status = this.status.dismount;
            }
        }

        public SkyhookStatus getStatus() {
            return this.status;
        }

        public void startHolding() {
            this.status = SkyhookStatus.HOLDING_CONNECTING;
        }

        public void startRiding() {
            this.status = this.status.mount;
        }
    }
}

