/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.model.ModelCloak;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemHolyCloak
extends ItemBauble {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/cloak_holy.png");
    private static final ResourceLocation textureGlow = new ResourceLocation("botania:textures/model/cloak_holy_glow.png");
    @OnlyIn(value=Dist.CLIENT)
    private static ModelCloak model;
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_IN_EFFECT = "inEffect";

    public ItemHolyCloak(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerDamage);
    }

    private void onPlayerDamage(LivingHurtEvent event) {
        PlayerEntity player;
        ItemStack stack;
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getSource().func_76357_e() && !(stack = EquipmentHandler.findOrEmpty(this, (LivingEntity)(player = (PlayerEntity)event.getEntityLiving()))).func_190926_b() && !ItemHolyCloak.isInEffect(stack)) {
            ItemHolyCloak cloak = (ItemHolyCloak)stack.func_77973_b();
            int cooldown = ItemHolyCloak.getCooldown(stack);
            ItemHolyCloak.setInEffect(stack, true);
            if (cooldown == 0 && cloak.effectOnDamage(event, player, stack)) {
                ItemHolyCloak.setCooldown(stack, cloak.getCooldownTime(stack));
            }
            ItemHolyCloak.setInEffect(stack, false);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        int cooldown = ItemHolyCloak.getCooldown(stack);
        if (cooldown > 0) {
            ItemHolyCloak.setCooldown(stack, cooldown - 1);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BaubleRenderHandler layer, ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemHolyCloak item = (ItemHolyCloak)stack.func_77973_b();
        AccessoryRenderHelper.rotateIfSneaking(ms, player);
        boolean armor = !player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
        ms.func_227861_a_(0.0, armor ? (double)-0.07f : (double)-0.01f, 0.0);
        if (model == null) {
            model = new ModelCloak();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(item.getCloakTexture());
        IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(item.getCloakTexture()));
        model.func_225598_a_(ms, buffer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        buffer = buffers.getBuffer(model.func_228282_a_(item.getCloakGlowTexture()));
        model.func_225598_a_(ms, buffer, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean effectOnDamage(LivingHurtEvent event, PlayerEntity player, ItemStack stack) {
        if (!event.getSource().func_82725_o()) {
            event.setCanceled(true);
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.holyCloak, SoundCategory.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = player.func_226277_ct_() + Math.random() * (double)player.func_213311_cf() * 2.0 - (double)player.func_213311_cf();
                double y = player.func_226278_cu_() + Math.random() * (double)player.func_213302_cg();
                double z = player.func_226281_cx_() + Math.random() * (double)player.func_213311_cf() * 2.0 - (double)player.func_213311_cf();
                boolean yellow = Math.random() > 0.5;
                float r = yellow ? 1.0f : 0.3f;
                float g = yellow ? 1.0f : 0.3f;
                float b = yellow ? 0.3f : 1.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.8f + (float)Math.random() * 0.4f, r, g, b, 3);
                player.field_70170_p.func_195594_a((IParticleData)data, x, y, z, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    public int getCooldownTime(ItemStack stack) {
        return 200;
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }

    public static boolean isInEffect(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_IN_EFFECT, false);
    }

    public static void setInEffect(ItemStack stack, boolean effect) {
        ItemNBTHelper.setBoolean(stack, TAG_IN_EFFECT, effect);
    }

    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getCloakTexture() {
        return texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }
}

