/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.impl.BotaniaAPIImpl;

public final class IMCHandler {
    public static void handle(InterModProcessEvent evt) {
        ((BotaniaAPIImpl)BotaniaAPI.instance()).oreWeights = IMCHandler.handleOreWeights(evt.getIMCStream("register_ore_weight"::equals));
        ((BotaniaAPIImpl)BotaniaAPI.instance()).netherOreWeights = IMCHandler.handleOreWeights(evt.getIMCStream("register_nether_ore_weight"::equals));
    }

    private static Map<ResourceLocation, Integer> handleOreWeights(Stream<InterModComms.IMCMessage> msgs) {
        Map<ResourceLocation, Integer> map = msgs.filter(msg -> {
            Object thing = msg.getMessageSupplier().get();
            if (thing instanceof Pair) {
                return ((Pair)thing).getFirst() instanceof ResourceLocation && ((Pair)thing).getSecond() instanceof Integer;
            }
            return false;
        }).map(msg -> (Pair)msg.getMessageSupplier().get()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        return ImmutableMap.copyOf(map);
    }
}

