/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileAvatar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;

public class BlockAvatar
extends BlockMod {
    private static final VoxelShape X_AABB = BlockAvatar.func_208617_a((double)5.0, (double)0.0, (double)3.5, (double)11.0, (double)17.0, (double)12.5);
    private static final VoxelShape Z_AABB = BlockAvatar.func_208617_a((double)3.5, (double)0.0, (double)5.0, (double)12.5, (double)17.0, (double)11.0);

    protected BlockAvatar(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        if (((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k() == Direction.Axis.X) {
            return X_AABB;
        }
        return Z_AABB;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileAvatar avatar = (TileAvatar)world.func_175625_s(pos);
        ItemStack stackOnAvatar = avatar.getItemHandler().getStackInSlot(0);
        ItemStack stackOnPlayer = player.func_184586_b(hand);
        if (!stackOnAvatar.func_190926_b()) {
            avatar.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stackOnAvatar);
            return ActionResultType.SUCCESS;
        }
        if (!stackOnPlayer.func_190926_b() && stackOnPlayer.func_77973_b() instanceof IAvatarWieldable) {
            avatar.getItemHandler().setStackInSlot(0, stackOnPlayer.func_77979_a(1));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newstate, boolean isMoving) {
        if (state.func_177230_c() != newstate.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newstate, isMoving);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileAvatar();
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
    }

    @Nonnull
    public BlockState func_185499_a(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
    }
}

