/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.ModelAvatar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAvatar;

public class RenderTileAvatar
extends TileEntityRenderer<TileAvatar> {
    private static final float[] ROTATIONS = new float[]{180.0f, 0.0f, 90.0f, 270.0f};
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/avatar.png");
    private static final ModelAvatar model = new ModelAvatar();

    public RenderTileAvatar(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nullable TileAvatar avatar, float pticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        ItemStack stack;
        if (!(avatar == null || avatar.func_145831_w().func_175667_e(avatar.func_174877_v()) && avatar.func_195044_w().func_177230_c() == ModBlocks.avatar)) {
            return;
        }
        ms.func_227860_a_();
        Direction facing = avatar != null && avatar.func_145831_w() != null ? (Direction)avatar.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J) : Direction.SOUTH;
        ms.func_227861_a_(0.5, (double)1.6f, 0.5);
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ROTATIONS[Math.max(Math.min(ROTATIONS.length - 1, facing.func_176745_a() - 2), 0)]));
        IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(texture));
        model.func_225598_a_(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (avatar != null && !(stack = avatar.getItemHandler().getStackInSlot(0)).func_190926_b()) {
            ms.func_227860_a_();
            float s = 0.6f;
            ms.func_227862_a_(s, s, s);
            ms.func_227861_a_(-0.5, 2.0, -0.25);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-70.0f));
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, light, overlay, ms, buffers);
            ms.func_227865_b_();
            IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
            buffer = buffers.getBuffer(RenderType.func_228644_e_((ResourceLocation)wieldable.getOverlayResource(avatar, stack)));
            s = 1.01f;
            ms.func_227860_a_();
            ms.func_227862_a_(s, s, s);
            ms.func_227861_a_(0.0, (double)-0.01f, 0.0);
            float alpha = (float)Math.sin((double)ClientTickHandler.ticksInGame / 20.0) / 2.0f + 0.5f;
            model.func_225598_a_(ms, buffer, 0xF000F0, overlay, 1.0f, 1.0f, 1.0f, alpha + 0.183f);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }
}

