/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.recipebook.RecipeBookPage;
import net.minecraft.client.gui.recipebook.RecipeWidget;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketIndexKeybindRequest;

@Mod.EventBusSubscriber(modid="botania", value={Dist.CLIENT})
public class CorporeaInputHandler {
    public static Supplier<ItemStack> jeiPanelSupplier = () -> ItemStack.field_190927_a;
    public static Predicate<Screen> supportedGuiFilter = gui -> gui instanceof ContainerScreen;

    @SubscribeEvent
    public static void buttonPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || !supportedGuiFilter.test(mc.field_71462_r) || event.getKeyCode() == 0 || ClientProxy.CORPOREA_REQUEST.getKey().func_197937_c() != event.getKeyCode() || TileCorporeaIndex.InputHandler.getNearbyIndexes((PlayerEntity)mc.field_71439_g).isEmpty()) {
            return;
        }
        ItemStack stack = CorporeaInputHandler.getStackUnderMouse();
        if (stack != null && !stack.func_190926_b()) {
            int count = 1;
            int max = stack.func_77976_d();
            if (Screen.hasShiftDown()) {
                count = max;
                if (Screen.hasControlDown()) {
                    count /= 4;
                }
            } else if (Screen.hasControlDown()) {
                count = max / 2;
            }
            if (count > 0) {
                ItemStack requested = stack.func_77946_l();
                requested.func_190920_e(count);
                PacketHandler.sendToServer(new PacketIndexKeybindRequest(requested));
                event.setCanceled(true);
            }
        }
    }

    private static ItemStack getStackUnderMouse() {
        Slot slotUnderMouse;
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof ContainerScreen && (slotUnderMouse = ((ContainerScreen)screen).getSlotUnderMouse()) != null) {
            ItemStack stack = slotUnderMouse.func_75211_c().func_77946_l();
            stack.func_77982_d(null);
            return stack;
        }
        if (screen instanceof InventoryScreen && ((InventoryScreen)screen).func_194310_f().func_191878_b()) {
            RecipeBookGui recipeBook = ((InventoryScreen)screen).func_194310_f();
            try {
                RecipeBookPage page = (RecipeBookPage)ObfuscationReflectionHelper.getPrivateValue(RecipeBookGui.class, (Object)recipeBook, (String)"field_193022_s");
                RecipeWidget widget = (RecipeWidget)ObfuscationReflectionHelper.getPrivateValue(RecipeBookPage.class, (Object)page, (String)"field_194201_b");
                if (widget != null) {
                    return widget.func_193760_e().func_77571_b();
                }
            }
            catch (Exception e) {
                Botania.LOGGER.error("Failed to get hovered recipe gui button", (Throwable)e);
            }
        }
        return jeiPanelSupplier.get();
    }
}

