/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.ItemAstrolabe;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public final class AstrolabePreviewHandler {
    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        MatrixStack ms = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.ASTROLABE_PREVIEW);
        for (PlayerEntity player : world.func_217369_A()) {
            Block block;
            ItemStack currentStack = player.func_184614_ca();
            if (currentStack.func_190926_b() || !(currentStack.func_77973_b() instanceof ItemAstrolabe)) {
                currentStack = player.func_184592_cb();
            }
            if (currentStack.func_190926_b() || !(currentStack.func_77973_b() instanceof ItemAstrolabe) || (block = ItemAstrolabe.getBlock(currentStack)) == Blocks.field_150350_a) continue;
            AstrolabePreviewHandler.renderPlayerLook(ms, buffer, player, currentStack);
        }
        buffers.func_228462_a_(RenderHelper.ASTROLABE_PREVIEW);
    }

    private static void renderPlayerLook(MatrixStack ms, IVertexBuilder buffer, PlayerEntity player, ItemStack stack) {
        List<BlockPos> coords = ItemAstrolabe.getBlocksToPlace(stack, player);
        if (ItemAstrolabe.hasBlocks(stack, player, coords)) {
            BlockState state = ItemAstrolabe.getBlockState(stack);
            for (BlockPos coord : coords) {
                AstrolabePreviewHandler.renderBlockAt(ms, buffer, state, coord);
            }
        }
    }

    private static void renderBlockAt(MatrixStack ms, IVertexBuilder buffer, BlockState state, BlockPos pos) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-renderPosX, -renderPosY, -renderPosZ);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        IBakedModel model = brd.func_184389_a(state);
        int color = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        brd.func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, state, model, r, g, b, 0xF000F0, OverlayTexture.field_229196_a_);
        ms.func_227865_b_();
    }
}

