/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SecurityCardItem
extends Item {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_OWNER_NAME = "OwnerName";
    private static final String NBT_PERMISSION = "Permission_%d";

    public SecurityCardItem() {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP).func_200917_a(1));
        this.setRegistryName("refinedstorage", "security_card");
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> entity != null && SecurityCardItem.isValid(stack) ? 1.0f : 0.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74778_a(NBT_OWNER, player.func_146103_bH().getId().toString());
            stack.func_77978_p().func_74778_a(NBT_OWNER_NAME, player.func_146103_bH().getName());
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Nullable
    public static UUID getOwner(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER)) {
            return UUID.fromString(stack.func_77978_p().func_74779_i(NBT_OWNER));
        }
        return null;
    }

    public static boolean hasPermission(ItemStack stack, Permission permission) {
        String id = String.format(NBT_PERMISSION, permission.getId());
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(id)) {
            return stack.func_77978_p().func_74767_n(id);
        }
        return false;
    }

    public static void setPermission(ItemStack stack, Permission permission, boolean state) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74757_a(String.format(NBT_PERMISSION, permission.getId()), state);
    }

    public static boolean isValid(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER_NAME)) {
            tooltip.add(new TranslationTextComponent("item.refinedstorage.security_card.owner", new Object[]{stack.func_77978_p().func_74779_i(NBT_OWNER_NAME)}).func_150255_a(Styles.GRAY));
        }
        for (Permission permission : Permission.values()) {
            if (!SecurityCardItem.hasPermission(stack, permission)) continue;
            tooltip.add(new StringTextComponent("- ").func_150257_a((ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission." + permission.getId(), new Object[0])).func_150255_a(Styles.GRAY));
        }
    }
}

