/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GridTab
implements IGridTab {
    private List<IFilter> filters;
    private String name;
    @Nonnull
    private ItemStack icon;
    @Nullable
    private FluidStack fluidIcon;

    public GridTab(List<IFilter> filters, String name, @Nonnull ItemStack icon, @Nullable FluidStack fluidIcon) {
        this.filters = filters;
        this.name = name;
        this.icon = icon;
        this.fluidIcon = fluidIcon;
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void drawTooltip(int x, int y, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
        if (!this.name.trim().equals("")) {
            GuiUtils.drawHoveringText(Collections.singletonList(this.name), (int)x, (int)y, (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)fontRenderer);
        }
    }

    @Override
    public void drawIcon(int x, int y, IElementDrawer<ItemStack> itemDrawer, IElementDrawer<FluidStack> fluidDrawer) {
        if (!this.icon.func_190926_b()) {
            RenderSystem.setupGui3DDiffuseLighting();
            itemDrawer.draw(x, y, this.icon);
        } else {
            fluidDrawer.draw(x, y, this.fluidIcon);
            RenderSystem.enableAlphaTest();
        }
    }
}

