/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.helper.Helper;

public class TombstoneActivatedMessage {
    private BlockPos currentPos;

    public TombstoneActivatedMessage(BlockPos currentPos) {
        this.currentPos = currentPos;
    }

    static TombstoneActivatedMessage fromBytes(PacketBuffer buf) {
        return new TombstoneActivatedMessage(BlockPos.func_218283_e((long)buf.readLong()));
    }

    static void toBytes(TombstoneActivatedMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.currentPos.func_218275_a());
    }

    public static class Handler {
        static void handle(TombstoneActivatedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    DedicatedServer server;
                    World world;
                    BlockState state;
                    Block block;
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null && (block = (state = (world = player.field_70170_p).func_180495_p(message.currentPos)).func_177230_c()) instanceof BlockGrave && player.func_184102_h() != null && player.func_184102_h().func_71262_S() && (server = (DedicatedServer)player.func_184102_h()).func_175579_a(world, message.currentPos, (PlayerEntity)player)) {
                        block.func_225533_a_(state, world, message.currentPos, (PlayerEntity)player, Hand.MAIN_HAND, new BlockRayTraceResult(new Vec3d((Vec3i)message.currentPos), Direction.DOWN, message.currentPos, true));
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

