/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.util.ThrowingConsumer;
import codechicken.lib.util.ThrowingFunction;
import codechicken.lib.util.ThrowingProducer;
import codechicken.lib.util.ThrowingRunnable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SneakyUtils {
    public static Runnable none() {
        return () -> {};
    }

    public static <T> Callable<T> nullC() {
        return () -> null;
    }

    public static <T> Supplier<T> nullS() {
        return () -> null;
    }

    public static Runnable concat(Runnable a, Runnable b) {
        return () -> {
            a.run();
            b.run();
        };
    }

    public static Runnable sneak(ThrowingRunnable<Throwable> tr) {
        return () -> SneakyUtils.sneaky(tr);
    }

    public static <T, R> Function<T, R> sneak(ThrowingFunction<T, R, Throwable> tf) {
        return e -> SneakyUtils.sneaky(() -> tf.apply(e));
    }

    public static void sneaky(ThrowingRunnable<Throwable> tr) {
        try {
            tr.run();
        }
        catch (Throwable t) {
            SneakyUtils.throwUnchecked(t);
        }
    }

    public static <T> T sneaky(ThrowingProducer<T, Throwable> tp) {
        try {
            return tp.get();
        }
        catch (Throwable t) {
            SneakyUtils.throwUnchecked(t);
            return null;
        }
    }

    public static <T> Consumer<T> sneakyL(ThrowingConsumer<T, Throwable> tc) {
        return t -> {
            try {
                tc.accept(t);
            }
            catch (Throwable th) {
                SneakyUtils.throwUnchecked(th);
            }
        };
    }

    public static <T> T unsafeCast(Object obj) {
        return (T)obj;
    }

    public static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw t;
    }
}

