/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.Uniform;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Matrix4;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL21;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL40;

public class ShaderUniformCache
implements UniformCache {
    private static final Logger logger = LogManager.getLogger();
    private final ShaderUniformCache parent;
    private final ShaderProgram program;
    private final ArrayDeque<ShaderUniformCache> pool = new ArrayDeque();
    private final Set<ShaderUniformCache> allocated = new HashSet<ShaderUniformCache>();
    private final Map<String, UniformEntry<?>> uniformEntries = new HashMap();
    private final Object2IntMap<String> locationCache = new Object2IntOpenHashMap();

    public ShaderUniformCache(ShaderProgram program) {
        this.parent = null;
        this.program = program;
        HashMap<String, String> uniformToShader = new HashMap<String, String>();
        for (ShaderObject shader : program.getShaders()) {
            for (Uniform uniform : shader.getUniforms()) {
                String existingOwner = (String)uniformToShader.get(uniform.getName());
                if (existingOwner != null) {
                    throw new IllegalArgumentException(String.format("ShaderObject '%s' tried to add a uniform with name '%s', already owned by ShaderObject '%s'", shader.getName(), uniform.getName(), existingOwner));
                }
                uniformToShader.put(uniform.getName(), shader.getName());
                this.uniformEntries.put(uniform.getName(), this.makeEntry(uniform));
            }
        }
    }

    public ShaderUniformCache(ShaderUniformCache parent, ShaderProgram program) {
        this.parent = parent;
        this.program = program;
        for (Map.Entry<String, UniformEntry<?>> entry : parent.uniformEntries.entrySet()) {
            this.uniformEntries.put(entry.getKey(), (UniformEntry<?>)entry.getValue().copy());
        }
    }

    public void onLink() {
        this.locationCache.clear();
        for (UniformEntry<?> entry : this.uniformEntries.values()) {
            entry.reset();
            Uniform uniform = entry.uniform;
            if (uniform.getType().isSupported()) continue;
            throw new IllegalStateException(String.format("Uniform '%s' is not supported in this environment.", uniform.getName()));
        }
    }

    public ShaderUniformCache pushCache() {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Nested caches isn't possible.");
        }
        ShaderUniformCache child = this.pool.poll();
        if (child == null) {
            child = new ShaderUniformCache(this, this.program);
            this.allocated.add(child);
            if (this.allocated.size() % 40 == 0) {
                logger.warn("Potential runaway UniformCache pushes. {} caches allocated.", (Object)this.allocated.size());
            }
        }
        for (Map.Entry<String, UniformEntry<?>> entry : this.uniformEntries.entrySet()) {
            child.uniformEntries.get(entry.getKey()).setupFrom((UniformEntry)SneakyUtils.unsafeCast(entry.getValue()));
        }
        return child;
    }

    public void popApply(ShaderUniformCache other) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Nested caches aren't possible.");
        }
        if (other.parent != this) {
            throw new IllegalArgumentException("The provided UniformCache is not owned by this UniformCache.");
        }
        for (UniformEntry<?> uniformEntry : other.uniformEntries.values()) {
            uniformEntry.push();
            uniformEntry.apply();
        }
        this.pool.push(other);
    }

    public void apply() {
        this.uniformEntries.values().forEach(UniformEntry::apply);
    }

    private int getLocation(String name) {
        if (this.parent != null) {
            return this.parent.getLocation(name);
        }
        return this.locationCache.computeIntIfAbsent((Object)name, e -> GL20.glGetUniformLocation((int)this.program.getProgramId(), (CharSequence)name));
    }

    private UniformEntry<?> makeEntry(Uniform uniform) {
        switch (uniform.getType().getCarrier()) {
            case INT: 
            case U_INT: {
                return new IntUniformEntry(uniform);
            }
            case FLOAT: 
            case MATRIX: {
                return new FloatUniformEntry(uniform);
            }
            case DOUBLE: 
            case D_MATRIX: {
                return new DoubleUniformEntry(uniform);
            }
        }
        throw new IllegalArgumentException("Unknown uniform carrier type.");
    }

    @Override
    public void glUniform1i(String name, int i0) {
        this.glUniformI(name, i0);
    }

    @Override
    public void glUniform2i(String name, int i0, int i1) {
        this.glUniformI(name, i0, i1);
    }

    @Override
    public void glUniform3i(String name, int i0, int i1, int i2) {
        this.glUniformI(name, i0, i1, i2);
    }

    @Override
    public void glUniform4i(String name, int i0, int i1, int i2, int i3) {
        this.glUniformI(name, i0, i1, i2, i3);
    }

    @Override
    public void glUniform1ui(String name, int i0) {
        this.glUniformI(name, i0);
    }

    @Override
    public void glUniform2ui(String name, int i0, int i1) {
        this.glUniformI(name, i0, i1);
    }

    @Override
    public void glUniform3ui(String name, int i0, int i1, int i2) {
        this.glUniformI(name, i0, i1, i2);
    }

    @Override
    public void glUniform4ui(String name, int i0, int i1, int i2, int i3) {
        this.glUniformI(name, i0, i1, i2, i3);
    }

    @Override
    public void glUniform1f(String name, float f0) {
        this.glUniformF(name, false, f0);
    }

    @Override
    public void glUniform2f(String name, float f0, float f1) {
        this.glUniformF(name, false, f0, f1);
    }

    @Override
    public void glUniform3f(String name, float f0, float f1, float f2) {
        this.glUniformF(name, false, f0, f1, f2);
    }

    @Override
    public void glUniform4f(String name, float f0, float f1, float f2, float f3) {
        this.glUniformF(name, false, f0, f1, f2, f3);
    }

    @Override
    public void glUniform1d(String name, float d0) {
        this.glUniformD(name, false, d0);
    }

    @Override
    public void glUniform2d(String name, float d0, float d1) {
        this.glUniformD(name, false, d0, d1);
    }

    @Override
    public void glUniform3d(String name, float d0, float d1, float d2) {
        this.glUniformD(name, false, d0, d1, d2);
    }

    @Override
    public void glUniform4d(String name, float d0, float d1, float d2, float d3) {
        this.glUniformD(name, false, d0, d1, d2, d3);
    }

    @Override
    public void glUniform1b(String name, boolean b0) {
        this.glUniform1i(name, b0 ? 1 : 0);
    }

    @Override
    public void glUniform2b(String name, boolean b0, boolean b1) {
        this.glUniform2i(name, b0 ? 1 : 0, b1 ? 1 : 0);
    }

    @Override
    public void glUniform3b(String name, boolean b0, boolean b1, boolean b2) {
        this.glUniform3i(name, b0 ? 1 : 0, b1 ? 1 : 0, b2 ? 1 : 0);
    }

    @Override
    public void glUniform4b(String name, boolean b0, boolean b1, boolean b2, boolean b3) {
        this.glUniform4i(name, b0 ? 1 : 0, b1 ? 1 : 0, b2 ? 1 : 0, b3 ? 1 : 0);
    }

    @Override
    public void glUniformMatrix2f(String name, float[] matrix) {
        this.glUniformMatrix2f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix2f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix2x3f(String name, float[] matrix) {
        this.glUniformMatrix2x3f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix2x3f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix2x4f(String name, float[] matrix) {
        this.glUniformMatrix2x4f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix2x4f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix3f(String name, float[] matrix) {
        this.glUniformMatrix3f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix3f(String name, Matrix3f matrix) {
        this.glUniformMatrix3f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3f(String name, boolean transpose, Matrix3f matrix) {
        this.glUniformF(name, transpose, ShaderUniformCache.toArrayF(matrix));
    }

    @Override
    public void glUniformMatrix3x2f(String name, float[] matrix) {
        this.glUniformMatrix3x2f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3x2f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix3x4f(String name, float[] matrix) {
        this.glUniformMatrix3x4f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3x4f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix4f(String name, float[] matrix) {
        this.glUniformMatrix4f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix4f(String name, Matrix4 matrix) {
        this.glUniformMatrix4f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4f(String name, boolean transpose, Matrix4 matrix) {
        this.glUniformMatrix4f(name, transpose, matrix.toArrayF());
    }

    @Override
    public void glUniformMatrix4f(String name, Matrix4f matrix) {
        this.glUniformMatrix4f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4f(String name, boolean transpose, Matrix4f matrix) {
        this.glUniformMatrix4f(name, transpose, new Matrix4(matrix));
    }

    @Override
    public void glUniformMatrix4x2f(String name, float[] matrix) {
        this.glUniformMatrix4x2f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4x2f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix4x3f(String name, float[] matrix) {
        this.glUniformMatrix4x3f(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4x3f(String name, boolean transpose, float[] matrix) {
        this.glUniformF(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix2d(String name, double[] matrix) {
        this.glUniformMatrix2d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix2d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix2x3d(String name, double[] matrix) {
        this.glUniformMatrix2x3d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix2x3d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix2x4d(String name, double[] matrix) {
        this.glUniformMatrix2x4d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix2x4d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix3d(String name, double[] matrix) {
        this.glUniformMatrix3d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix3d(String name, Matrix3f matrix) {
        this.glUniformMatrix3d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3d(String name, boolean transpose, Matrix3f matrix) {
        this.glUniformD(name, transpose, ShaderUniformCache.toArrayD(matrix));
    }

    @Override
    public void glUniformMatrix3x2d(String name, double[] matrix) {
        this.glUniformMatrix3x2d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3x2d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix3x4d(String name, double[] matrix) {
        this.glUniformMatrix3x4d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix3x4d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix4d(String name, double[] matrix) {
        this.glUniformMatrix4d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4d(String name, Matrix4 matrix) {
        this.glUniformMatrix4d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4d(String name, boolean transpose, Matrix4 matrix) {
        this.glUniformMatrix4d(name, transpose, matrix.toArrayD());
    }

    @Override
    public void glUniformMatrix4d(String name, Matrix4f matrix) {
        this.glUniformMatrix4d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4d(String name, boolean transpose, Matrix4f matrix) {
        this.glUniformMatrix4d(name, transpose, new Matrix4(matrix));
    }

    @Override
    public void glUniformMatrix4d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix4x2d(String name, double[] matrix) {
        this.glUniformMatrix4x2d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4x2d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    @Override
    public void glUniformMatrix4x3d(String name, double[] matrix) {
        this.glUniformMatrix4x3d(name, false, matrix);
    }

    @Override
    public void glUniformMatrix4x3d(String name, boolean transpose, double[] matrix) {
        this.glUniformD(name, transpose, matrix);
    }

    private void glUniformI(String name, int ... values) {
        UniformEntry<?> entry = this.uniformEntries.get(name);
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Uniform with name '%s' does not exist.", name));
        }
        UniformType type = entry.uniform.getType();
        if (!(entry instanceof IntUniformEntry)) {
            throw new IllegalArgumentException(String.format("Uniform with name '%s' isn't registered with the carrier of INT, Got type '%s' with carrier '%s'.", new Object[]{name, type, type.getCarrier()}));
        }
        if (type.getSize() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid uniform length, Expected: '%s', Got: '%s'.", type.getSize(), values.length));
        }
        ((IntUniformEntry)entry).set(values, false);
    }

    private void glUniformF(String name, boolean transpose, float ... values) {
        UniformEntry<?> entry = this.uniformEntries.get(name);
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Uniform with name '%s' does not exist.", name));
        }
        UniformType type = entry.uniform.getType();
        if (!(entry instanceof FloatUniformEntry)) {
            throw new IllegalArgumentException(String.format("Uniform with name '%s' isn't registered with the carrier of FLOAT or MATRIX, Got type '%s' with carrier '%s'.", new Object[]{name, type, type.getCarrier()}));
        }
        if (type.getSize() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid uniform length, Expected: '%s', Got: '%s'.", type.getSize(), values.length));
        }
        ((FloatUniformEntry)entry).set(values, transpose);
    }

    private void glUniformD(String name, boolean transpose, double ... values) {
        UniformEntry<?> entry = this.uniformEntries.get(name);
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Uniform with name '%s' does not exist.", name));
        }
        UniformType type = entry.uniform.getType();
        if (!(entry instanceof DoubleUniformEntry)) {
            throw new IllegalArgumentException(String.format("Uniform with name '%s' isn't registered with the carrier of DOUBLE or D_MATRIX, Got type '%s' with carrier '%s'.", new Object[]{name, type, type.getCarrier()}));
        }
        if (type.getSize() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid uniform length, Expected: '%s', Got: '%s'.", type.getSize(), values.length));
        }
        ((DoubleUniformEntry)entry).set(values, transpose);
    }

    private static double[] toArrayD(Matrix3f matrix) {
        return new double[]{matrix.field_226097_a_, matrix.field_226098_b_, matrix.field_226099_c_, matrix.field_226100_d_, matrix.field_226101_e_, matrix.field_226102_f_, matrix.field_226103_g_, matrix.field_226104_h_, matrix.field_226105_i_};
    }

    private static float[] toArrayF(Matrix3f matrix) {
        return new float[]{matrix.field_226097_a_, matrix.field_226098_b_, matrix.field_226099_c_, matrix.field_226100_d_, matrix.field_226101_e_, matrix.field_226102_f_, matrix.field_226103_g_, matrix.field_226104_h_, matrix.field_226105_i_};
    }

    private class DoubleUniformEntry
    extends UniformEntry<double[]> {
        public DoubleUniformEntry(Uniform uniform) {
            super(uniform);
        }

        private DoubleUniformEntry(DoubleUniformEntry other) {
            super(other);
        }

        @Override
        public void apply() {
            if (this.dirty) {
                block0 : switch (this.type.getCarrier()) {
                    case DOUBLE: {
                        switch (this.type.getSize()) {
                            case 1: {
                                GL40.glUniform1d((int)this.getLocation(), (double)((double[])this.cache)[0]);
                                break block0;
                            }
                            case 2: {
                                GL40.glUniform2d((int)this.getLocation(), (double)((double[])this.cache)[0], (double)((double[])this.cache)[1]);
                                break block0;
                            }
                            case 3: {
                                GL40.glUniform3d((int)this.getLocation(), (double)((double[])this.cache)[0], (double)((double[])this.cache)[1], (double)((double[])this.cache)[2]);
                                break block0;
                            }
                            case 4: {
                                GL40.glUniform4d((int)this.getLocation(), (double)((double[])this.cache)[0], (double)((double[])this.cache)[1], (double)((double[])this.cache)[2], (double)((double[])this.cache)[3]);
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Invalid size for Double type." + this.type.getSize());
                    }
                    case MATRIX: {
                        switch (this.type) {
                            case D_MAT2: {
                                GL40.glUniformMatrix2dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT3: {
                                GL40.glUniformMatrix3dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT4: {
                                GL40.glUniformMatrix4dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT2x3: {
                                GL40.glUniformMatrix2x3dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT2x4: {
                                GL40.glUniformMatrix2x4dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT3x2: {
                                GL40.glUniformMatrix3x2dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT3x4: {
                                GL40.glUniformMatrix3x4dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT4x2: {
                                GL40.glUniformMatrix4x2dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                            case D_MAT4x3: {
                                GL40.glUniformMatrix4x3dv((int)this.getLocation(), (boolean)this.transpose, (double[])((double[])this.cache));
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Invalid Matrix type: " + (Object)((Object)this.type));
                    }
                    default: {
                        throw new IllegalStateException("Invalid type for DoubleUniformEntry: " + (Object)((Object)this.type.getCarrier()));
                    }
                }
                this.dirty = false;
            }
        }

        @Override
        public double[] make(int len) {
            return new double[len];
        }

        @Override
        public int len(double[] cache) {
            return cache.length;
        }

        @Override
        public double[] clone(double[] other) {
            return (double[])other.clone();
        }

        @Override
        public boolean equals(double[] a, double[] b) {
            return Arrays.equals(a, b);
        }

        @Override
        public UniformEntry<double[]> copy() {
            return new DoubleUniformEntry(this);
        }
    }

    private class FloatUniformEntry
    extends UniformEntry<float[]> {
        public FloatUniformEntry(Uniform uniform) {
            super(uniform);
        }

        private FloatUniformEntry(FloatUniformEntry other) {
            super(other);
        }

        @Override
        public void apply() {
            if (this.dirty) {
                block0 : switch (this.type.getCarrier()) {
                    case FLOAT: {
                        switch (this.type.getSize()) {
                            case 1: {
                                GL20.glUniform1f((int)this.getLocation(), (float)((float[])this.cache)[0]);
                                break block0;
                            }
                            case 2: {
                                GL20.glUniform2f((int)this.getLocation(), (float)((float[])this.cache)[0], (float)((float[])this.cache)[1]);
                                break block0;
                            }
                            case 3: {
                                GL20.glUniform3f((int)this.getLocation(), (float)((float[])this.cache)[0], (float)((float[])this.cache)[1], (float)((float[])this.cache)[2]);
                                break block0;
                            }
                            case 4: {
                                GL20.glUniform4f((int)this.getLocation(), (float)((float[])this.cache)[0], (float)((float[])this.cache)[1], (float)((float[])this.cache)[2], (float)((float[])this.cache)[3]);
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Invalid size for Float type." + this.type.getSize());
                    }
                    case D_MATRIX: {
                        switch (this.type) {
                            case MAT2: {
                                GL20.glUniformMatrix2fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT3: {
                                GL20.glUniformMatrix3fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT4: {
                                GL20.glUniformMatrix4fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT2x3: {
                                GL21.glUniformMatrix2x3fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT2x4: {
                                GL21.glUniformMatrix2x4fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT3x2: {
                                GL21.glUniformMatrix3x2fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT3x4: {
                                GL21.glUniformMatrix3x4fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT4x2: {
                                GL21.glUniformMatrix4x2fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                            case MAT4x3: {
                                GL21.glUniformMatrix4x3fv((int)this.getLocation(), (boolean)this.transpose, (float[])((float[])this.cache));
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Invalid Matrix type: " + (Object)((Object)this.type));
                    }
                    default: {
                        throw new IllegalStateException("Invalid type for FloatUniformEntry: " + (Object)((Object)this.type.getCarrier()));
                    }
                }
                this.dirty = false;
            }
        }

        @Override
        public float[] make(int len) {
            return new float[len];
        }

        @Override
        public int len(float[] cache) {
            return cache.length;
        }

        @Override
        public float[] clone(float[] other) {
            return (float[])other.clone();
        }

        @Override
        public boolean equals(float[] a, float[] b) {
            return Arrays.equals(a, b);
        }

        @Override
        public UniformEntry<float[]> copy() {
            return new FloatUniformEntry(this);
        }
    }

    public class IntUniformEntry
    extends UniformEntry<int[]> {
        public IntUniformEntry(Uniform uniform) {
            super(uniform);
        }

        private IntUniformEntry(IntUniformEntry other) {
            super(other);
        }

        @Override
        public void apply() {
            if (this.dirty) {
                block0 : switch (this.type.getCarrier()) {
                    case INT: {
                        switch (this.type.getSize()) {
                            case 1: {
                                GL20.glUniform1i((int)this.getLocation(), (int)((int[])this.cache)[0]);
                                break block0;
                            }
                            case 2: {
                                GL20.glUniform2i((int)this.getLocation(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1]);
                                break block0;
                            }
                            case 3: {
                                GL20.glUniform3i((int)this.getLocation(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2]);
                                break block0;
                            }
                            case 4: {
                                GL20.glUniform4i((int)this.getLocation(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2], (int)((int[])this.cache)[3]);
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Invalid size for Int type." + this.type.getSize());
                    }
                    case U_INT: {
                        switch (this.type.getSize()) {
                            case 1: {
                                GL30.glUniform1ui((int)this.getLocation(), (int)((int[])this.cache)[0]);
                                break block0;
                            }
                            case 2: {
                                GL30.glUniform2ui((int)this.getLocation(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1]);
                                break block0;
                            }
                            case 3: {
                                GL30.glUniform3ui((int)this.getLocation(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2]);
                                break block0;
                            }
                            case 4: {
                                GL30.glUniform4ui((int)this.getLocation(), (int)((int[])this.cache)[0], (int)((int[])this.cache)[1], (int)((int[])this.cache)[2], (int)((int[])this.cache)[3]);
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Invalid size for Int type." + this.type.getSize());
                    }
                    default: {
                        throw new IllegalStateException("Invalid type for IntUniformEntry: " + (Object)((Object)this.type.getCarrier()));
                    }
                }
                this.dirty = false;
            }
        }

        @Override
        public int[] make(int len) {
            return new int[len];
        }

        @Override
        public int len(int[] cache) {
            return cache.length;
        }

        @Override
        public int[] clone(int[] other) {
            return (int[])other.clone();
        }

        @Override
        public boolean equals(int[] a, int[] b) {
            return Arrays.equals(a, b);
        }

        @Override
        public UniformEntry<int[]> copy() {
            return new IntUniformEntry(this);
        }
    }

    public abstract class UniformEntry<T>
    implements Copyable<UniformEntry<T>> {
        protected final UniformEntry<T> parent;
        protected final Uniform uniform;
        protected final UniformType type;
        protected T cache;
        protected boolean transpose;
        protected boolean dirty;
        private int location = -1;

        protected UniformEntry(Uniform uniform) {
            this.parent = null;
            this.uniform = uniform;
            this.type = uniform.getType();
            this.reset();
        }

        protected UniformEntry(UniformEntry<T> other) {
            if (other.parent != null) {
                throw new IllegalArgumentException("Cannot make clone of a clone.");
            }
            this.parent = other;
            this.uniform = other.uniform;
            this.type = other.type;
            this.dirty = other.dirty;
            this.location = other.location;
        }

        public void setupFrom(UniformEntry<T> other) {
            this.cache = this.clone(other.cache);
            this.transpose = false;
            this.dirty = false;
        }

        public void push() {
            this.parent.set(this);
        }

        public void set(UniformEntry<T> other) {
            this.set(other.cache, other.transpose);
        }

        public void set(T values, boolean transpose) {
            if (transpose && (this.type.getCarrier() != UniformType.Carrier.MATRIX || this.type.getCarrier() != UniformType.Carrier.D_MATRIX)) {
                throw new IllegalArgumentException("Transpose only supported for MATRIX and D_MATRIX carrier types.");
            }
            if (this.type.getCarrier() == UniformType.Carrier.INT && transpose) {
                throw new IllegalArgumentException("Transpose not supported for all Integer uniform types.");
            }
            if (this.len(values) != this.type.getSize()) {
                throw new IllegalArgumentException(String.format("Invalid size for uniform '%s', Expected: '%s', Got: '%s'.", this.uniform.getName(), this.type.getSize(), this.len(values)));
            }
            if (!this.equals(this.cache, values) || this.transpose != transpose) {
                this.cache = values;
                this.transpose = transpose;
                this.dirty = true;
            }
        }

        public int getLocation() {
            if (this.location == -1) {
                if (!this.uniform.getType().isSupported()) {
                    throw new IllegalStateException("Unsupported Uniform type.");
                }
                this.location = ShaderUniformCache.this.getLocation(this.uniform.getName());
            }
            return this.location;
        }

        public void reset() {
            this.cache = this.make(this.type.getSize());
            this.location = -1;
        }

        public abstract void apply();

        public abstract T make(int var1);

        public abstract int len(T var1);

        public abstract T clone(T var1);

        public abstract boolean equals(T var1, T var2);
    }
}

