/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.api;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.INBTSerializable;

public class Frequency
implements INBTSerializable<CompoundNBT> {
    private UUID owner;
    private String ownerText;
    private int channel;

    public Frequency() {
        this(1);
    }

    public Frequency(int channel) {
        this(null, channel);
    }

    public Frequency(@Nullable PlayerEntity player, int channel) {
        if (player == null) {
            this.owner = null;
            this.ownerText = "public";
        } else {
            this.owner = player.func_110124_au();
            this.ownerText = player.func_200200_C_().func_150254_d();
        }
        this.channel = channel;
    }

    private Frequency(String ownerText, @Nullable UUID owner, int channel) {
        this.ownerText = ownerText;
        this.owner = owner;
        this.channel = channel;
    }

    public Frequency(CompoundNBT tagCompound) {
        this.deserializeNBT(tagCompound);
    }

    public Frequency set(Frequency frequency) {
        this.ownerText = frequency.ownerText;
        this.owner = frequency.owner;
        this.channel = frequency.channel;
        return this;
    }

    public Frequency copy() {
        return new Frequency(this.ownerText, this.owner, this.channel);
    }

    public Frequency setOwner(@Nonnull PlayerEntity player) {
        this.owner = player.func_110124_au();
        this.ownerText = player.func_200200_C_().func_150254_d();
        return this;
    }

    public Frequency setPublic() {
        this.owner = null;
        this.ownerText = "public";
        return this;
    }

    public Frequency setChannel(int channel) {
        this.channel = channel;
        return this;
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public String getOwner() {
        return this.ownerText;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean hasOwner() {
        return !this.ownerText.equals("public") && this.owner != null;
    }

    public String toString() {
        return "owner=" + (this.hasOwner() ? this.owner : "public") + ",channel=" + this.channel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency f = (Frequency)obj;
        if (f.hasOwner()) {
            return f.channel == this.channel && f.owner.equals(this.owner) && f.ownerText.equals(this.ownerText);
        }
        return f.channel == this.channel && f.ownerText.equals(this.ownerText);
    }

    public static Frequency readFromPacket(PacketBuffer buf) {
        return new Frequency(buf.func_150789_c(Short.MAX_VALUE), buf.readBoolean() ? buf.func_179253_g() : null, buf.func_150792_a());
    }

    public void writeToPacket(PacketBuffer buf) {
        buf.func_180714_a(this.ownerText);
        buf.writeBoolean(this.hasOwner());
        if (this.hasOwner()) {
            buf.func_179252_a(this.owner);
        }
        buf.func_150787_b(this.channel);
    }

    public boolean canAccess(@Nonnull PlayerEntity player) {
        if (!this.hasOwner()) {
            return true;
        }
        return this.getOwnerUUID().equals(player.func_110124_au());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74778_a("ownerText", this.ownerText);
        if (this.hasOwner()) {
            tagCompound.func_186854_a("owner", this.owner);
        }
        tagCompound.func_74768_a("channel", this.channel);
        return tagCompound;
    }

    public void deserializeNBT(CompoundNBT tagCompound) {
        this.ownerText = tagCompound.func_74779_i("ownerText");
        this.owner = !this.ownerText.equals("public") ? tagCompound.func_186857_a("owner") : null;
        this.channel = tagCompound.func_74762_e("channel");
    }
}

