/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.reference.Ores;
import com.thevortex.potionsmaster.render.util.BlockData;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import com.thevortex.potionsmaster.render.util.BlockStore;
import com.thevortex.potionsmaster.render.util.StructureData;
import com.thevortex.potionsmaster.render.util.WorldRegion;
import com.thevortex.potionsmaster.render.util.xray.Controller;
import com.thevortex.potionsmaster.render.util.xray.Render;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public class RenderEnqueue
implements Runnable {
    private final WorldRegion box;

    public RenderEnqueue(WorldRegion region) {
        this.box = region;
    }

    @Override
    public void run() {
        this.blockFinder();
    }

    private void blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        HashMap<UUID, StructureData> structures = Controller.getStructureStore().getStore();
        if (structures.isEmpty() && !Render.structures.isEmpty()) {
            Render.structures.clear();
        }
        if (blocks.isEmpty() && !Render.ores.isEmpty()) {
            Render.ores.clear();
        }
        World world = PotionsMaster.proxy.getClientPlayer().field_70170_p;
        Collection playerEffects = PotionsMaster.proxy.getClientPlayer().func_70651_bq();
        PlayerEntity player = PotionsMaster.proxy.getClientPlayer();
        ArrayList<BlockInfo> renderQueue = new ArrayList<BlockInfo>();
        for (int chunkX = this.box.minChunkX; chunkX <= this.box.maxChunkX; ++chunkX) {
            int x = chunkX << 4;
            int lowBoundX = x < this.box.minX ? this.box.minX - x : 0;
            int highBoundX = x + 15 > this.box.maxX ? this.box.maxX - x : 15;
            for (int chunkZ = this.box.minChunkZ; chunkZ <= this.box.maxChunkZ; ++chunkZ) {
                if (!world.func_217354_b(chunkX, chunkZ)) continue;
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                ChunkSection[] extendsList = chunk.func_76587_i();
                int z = chunkZ << 4;
                int lowBoundZ = z < this.box.minZ ? this.box.minZ - z : 0;
                int highBoundZ = z + 15 > this.box.maxZ ? this.box.maxZ - z : 15;
                for (int curExtend = this.box.minChunkY; curExtend <= this.box.maxChunkY; ++curExtend) {
                    ChunkSection ebs = extendsList[curExtend];
                    if (ebs == null) continue;
                    int y = curExtend << 4;
                    int lowBoundY = y < this.box.minY ? this.box.minY - y : 0;
                    int highBoundY = y + 15 > this.box.maxY ? this.box.maxY - y : 15;
                    for (int i = lowBoundX; i <= highBoundX; ++i) {
                        for (int j = lowBoundY; j <= highBoundY; ++j) {
                            for (int k = lowBoundZ; k <= highBoundZ; ++k) {
                                BlockStore.BlockDataWithUUID dataWithUUID;
                                BlockState currentState = ebs.func_177485_a(i, j, k);
                                ResourceLocation block = currentState.func_177230_c().getRegistryName();
                                if (block == null) continue;
                                if (currentState.func_177230_c().getTags().contains(Ores.DIAMOND)) {
                                    block = Ores.DIAMOND;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.LAPIS)) {
                                    block = Ores.LAPIS;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.ALUMINIUM)) {
                                    block = Ores.ALUMINIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.COPPER)) {
                                    block = Ores.COPPER;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.TIN)) {
                                    block = Ores.TIN;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.LEAD)) {
                                    block = Ores.LEAD;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.SILVER)) {
                                    block = Ores.SILVER;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.GOLD)) {
                                    block = Ores.GOLD;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.URANIUM)) {
                                    block = Ores.URANIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.NICKEL)) {
                                    block = Ores.NICKEL;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.IRON)) {
                                    block = Ores.IRON;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.OSMIUM)) {
                                    block = Ores.OSMIUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.ZINC)) {
                                    block = Ores.ZINC;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.EMERALD)) {
                                    block = Ores.EMERALD;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.COAL)) {
                                    block = Ores.COAL;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.REDSTONE)) {
                                    block = Ores.REDSTONE;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.QUARTZ)) {
                                    block = Ores.QUARTZ;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.BISMUTH)) {
                                    block = Ores.BISMUTH;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.CRIMSONIRON)) {
                                    block = Ores.CRIMSONIRON;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.PLATINUM)) {
                                    block = Ores.PLATINUM;
                                }
                                if (currentState.func_177230_c().getTags().contains(Ores.ALLTHEMODIUM)) {
                                    block = Ores.ALLTHEMODIUM;
                                }
                                if ((dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString())) == null || dataWithUUID.getBlockData() == null || !dataWithUUID.getBlockData().isDrawing()) continue;
                                double alpha = Math.max(0.0, (double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().func_70092_e((double)(x + i), (double)(y + j), (double)(z + k)) / (double)(Controller.getRadius() / 4));
                                renderQueue.add(new BlockInfo(x + i, y + j, z + k, dataWithUUID.getBlockData().getColor().getColor(), alpha));
                            }
                        }
                    }
                }
            }
        }
        renderQueue.sort((t, t1) -> Double.compare(t1.func_177951_i((Vec3i)player.func_180425_c()), t.func_177951_i((Vec3i)player.func_180425_c())));
        Render.ores.clear();
        Render.ores.addAll(renderQueue);
    }

    public static void checkBlock(BlockPos pos, BlockState state, boolean add) {
        if (!Controller.drawOres() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        String defaultState = state.func_177230_c().func_176223_P().toString();
        if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
            if (!add) {
                Render.ores.remove((Object)new BlockInfo((Vec3i)pos, null, 0.0));
                return;
            }
            BlockData data = null;
            if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
                data = Controller.getBlockStore().getStore().get(defaultState);
            }
            if (data == null) {
                return;
            }
            double alpha = Math.max(0.0, ((double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) / (double)Controller.getRadius() * 255.0);
            Render.ores.add(new BlockInfo((Vec3i)pos, data.getColor().getColor(), alpha));
        }
    }
}

