/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CuriosConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final String CONFIG_PREFIX = "gui.curios.config.";

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue renderCurios;
        public final ForgeConfigSpec.IntValue buttonXOffset;
        public final ForgeConfigSpec.IntValue buttonYOffset;
        public final ForgeConfigSpec.IntValue creativeButtonXOffset;
        public final ForgeConfigSpec.IntValue creativeButtonYOffset;
        public final ForgeConfigSpec.EnumValue<ButtonCorner> buttonCorner;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.renderCurios = builder.comment("Set to true to enable rendering curios").translation("gui.curios.config.renderCurios").define("renderCurios", true);
            this.buttonXOffset = builder.comment("The X-Offset for the Curios GUI button").translation("gui.curios.config.buttonXOffset").defineInRange("buttonXOffset", 0, -100, 100);
            this.buttonYOffset = builder.comment("The Y-Offset for the Curios GUI button").translation("gui.curios.config.buttonYOffset").defineInRange("buttonYOffset", 0, -100, 100);
            this.creativeButtonXOffset = builder.comment("The X-Offset for the Creative Curios GUI button").translation("gui.curios.config.creativeButtonXOffset").defineInRange("creativeButtonXOffset", 0, -100, 100);
            this.creativeButtonYOffset = builder.comment("The Y-Offset for the Creative Curios GUI button").translation("gui.curios.config.creativeButtonYOffset").defineInRange("creativeButtonYOffset", 0, -100, 100);
            this.buttonCorner = builder.comment("The corner for the Curios GUI button").translation("gui.curios.config.buttonCorner").defineEnum("buttonCorner", (Enum)ButtonCorner.TOP_LEFT);
            builder.pop();
        }

        public static enum ButtonCorner {
            TOP_LEFT(26, -75, 73, -62),
            TOP_RIGHT(61, -75, 95, -62),
            BOTTOM_LEFT(26, -20, 73, -29),
            BOTTOM_RIGHT(61, -20, 95, -29);

            final int xoffset;
            final int yoffset;
            final int creativeXoffset;
            final int creativeYoffset;

            private ButtonCorner(int x, int y, int creativeX, int creativeY) {
                this.xoffset = x;
                this.yoffset = y;
                this.creativeXoffset = creativeX;
                this.creativeYoffset = creativeY;
            }

            public int getXoffset() {
                return this.xoffset;
            }

            public int getYoffset() {
                return this.yoffset;
            }

            public int getCreativeXoffset() {
                return this.creativeXoffset;
            }

            public int getCreativeYoffset() {
                return this.creativeYoffset;
            }
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<String>> disabledCurios;
        public final ForgeConfigSpec.ConfigValue<List<String>> createCurios;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            this.disabledCurios = builder.comment("List of curio types to disable by default").translation("gui.curios.config.disabledCurios").worldRestart().define("disabledCurios", (Object)Lists.newArrayList());
            this.createCurios = builder.comment("List of curio types to create.Sizes can be defined by adding a semicolon and the size number (e.g. 'ring;4').").translation("gui.curios.config.createCurios").worldRestart().define("createCurios", (Object)Lists.newArrayList());
            builder.pop();
        }
    }
}

