/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ComparatorBlock
extends RedstoneDiodeBlock
implements ITileEntityProvider {
    public static final EnumProperty<ComparatorMode> field_176463_b = BlockStateProperties.field_208141_ap;

    public ComparatorBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, Direction.NORTH)).func_206870_a(field_196348_c, false)).func_206870_a(field_176463_b, ComparatorMode.COMPARE));
    }

    @Override
    protected int func_196346_i(BlockState blockState) {
        return 2;
    }

    @Override
    protected int func_176408_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState) {
        TileEntity tileEntity = iBlockReader.func_175625_s(blockPos);
        if (tileEntity instanceof ComparatorTileEntity) {
            return ((ComparatorTileEntity)tileEntity).func_145996_a();
        }
        return 0;
    }

    private int func_176460_j(World world, BlockPos blockPos, BlockState blockState) {
        if (blockState.func_177229_b(field_176463_b) == ComparatorMode.SUBTRACT) {
            return Math.max(this.func_176397_f(world, blockPos, blockState) - this.func_176407_c(world, blockPos, blockState), 0);
        }
        return this.func_176397_f(world, blockPos, blockState);
    }

    @Override
    protected boolean func_176404_e(World world, BlockPos blockPos, BlockState blockState) {
        int n = this.func_176397_f(world, blockPos, blockState);
        if (n == 0) {
            return false;
        }
        \u2603 = this.func_176407_c(world, blockPos, blockState);
        if (n > \u2603) {
            return true;
        }
        return n == \u2603 && blockState.func_177229_b(field_176463_b) == ComparatorMode.COMPARE;
    }

    @Override
    protected int func_176397_f(World world, BlockPos blockPos, BlockState blockState) {
        int n = super.func_176397_f(world, blockPos, blockState);
        Direction \u26032 = blockState.func_177229_b(field_185512_D);
        BlockPos \u26033 = blockPos.func_177972_a(\u26032);
        BlockState \u26034 = world.func_180495_p(\u26033);
        if (\u26034.func_185912_n()) {
            n = \u26034.func_185888_a(world, \u26033);
        } else if (n < 15 && \u26034.func_215686_e(world, \u26033)) {
            \u26034 = world.func_180495_p(\u26033 = \u26033.func_177972_a(\u26032));
            if (\u26034.func_185912_n()) {
                n = \u26034.func_185888_a(world, \u26033);
            } else if (\u26034.func_196958_f() && (\u2603 = this.func_176461_a(world, \u26032, \u26033)) != null) {
                n = \u2603.func_174866_q();
            }
        }
        return n;
    }

    @Nullable
    private ItemFrameEntity func_176461_a(World world, Direction direction, BlockPos blockPos) {
        List<ItemFrameEntity> list = world.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n() + 1, blockPos.func_177956_o() + 1, blockPos.func_177952_p() + 1), itemFrameEntity -> itemFrameEntity != null && itemFrameEntity.func_174811_aO() == direction);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (!playerEntity.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        float f = (blockState = (BlockState)blockState.func_177231_a(field_176463_b)).func_177229_b(field_176463_b) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        world.func_184133_a(playerEntity, blockPos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, f);
        world.func_180501_a(blockPos, blockState, 2);
        this.func_176462_k(world, blockPos, blockState);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void func_176398_g(World world, BlockPos blockPos, BlockState blockState) {
        if (world.func_205220_G_().func_205361_b(blockPos, this)) {
            return;
        }
        int n = this.func_176460_j(world, blockPos, blockState);
        TileEntity \u26032 = world.func_175625_s(blockPos);
        int n2 = \u2603 = \u26032 instanceof ComparatorTileEntity ? ((ComparatorTileEntity)\u26032).func_145996_a() : 0;
        if (n != \u2603 || blockState.func_177229_b(field_196348_c).booleanValue() != this.func_176404_e(world, blockPos, blockState)) {
            TickPriority tickPriority = this.func_176402_i(world, blockPos, blockState) ? TickPriority.HIGH : TickPriority.NORMAL;
            world.func_205220_G_().func_205362_a(blockPos, this, 2, tickPriority);
        }
    }

    private void func_176462_k(World world, BlockPos blockPos, BlockState blockState) {
        int \u26033;
        int n = this.func_176460_j(world, blockPos, blockState);
        TileEntity \u26032 = world.func_175625_s(blockPos);
        \u26033 = 0;
        if (\u26032 instanceof ComparatorTileEntity) {
            ComparatorTileEntity comparatorTileEntity = (ComparatorTileEntity)\u26032;
            \u26033 = comparatorTileEntity.func_145996_a();
            comparatorTileEntity.func_145995_a(n);
        }
        if (\u26033 != n || blockState.func_177229_b(field_176463_b) == ComparatorMode.COMPARE) {
            boolean \u26034 = this.func_176404_e(world, blockPos, blockState);
            boolean \u26035 = blockState.func_177229_b(field_196348_c);
            if (\u26035 && !\u26034) {
                world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_196348_c, false), 2);
            } else if (!\u26035 && \u26034) {
                world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_196348_c, true), 2);
            }
            this.func_176400_h(world, blockPos, blockState);
        }
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.func_176462_k(serverWorld, blockPos, blockState);
    }

    @Override
    public boolean func_189539_a(BlockState blockState, World world, BlockPos blockPos, int n, int n2) {
        super.func_189539_a(blockState, world, blockPos, n, n2);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        return tileEntity != null && tileEntity.func_145842_c(n, n2);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new ComparatorTileEntity();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176463_b, field_196348_c);
    }
}

