/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameType;

public class PlayerPredicate {
    public static final PlayerPredicate field_226989_a_ = new Default().func_227012_b_();
    private final MinMaxBounds.IntBound field_226990_b_;
    private final GameType field_226991_c_;
    private final Map<Stat<?>, MinMaxBounds.IntBound> field_226992_d_;
    private final Object2BooleanMap<ResourceLocation> field_226993_e_;
    private final Map<ResourceLocation, IAdvancementPredicate> field_226994_f_;

    private static IAdvancementPredicate func_227004_b_(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            boolean bl = jsonElement.getAsBoolean();
            return new CompletedAdvancementPredicate(bl);
        }
        Object2BooleanOpenHashMap object2BooleanOpenHashMap = new Object2BooleanOpenHashMap();
        JsonObject \u26032 = JSONUtils.func_151210_l(jsonElement, "criterion data");
        \u26032.entrySet().forEach(arg_0 -> PlayerPredicate.func_227003_a_((Object2BooleanMap)object2BooleanOpenHashMap, arg_0));
        return new CriteriaPredicate((Object2BooleanMap<String>)object2BooleanOpenHashMap);
    }

    private PlayerPredicate(MinMaxBounds.IntBound intBound, GameType gameType, Map<Stat<?>, MinMaxBounds.IntBound> map, Object2BooleanMap<ResourceLocation> object2BooleanMap, Map<ResourceLocation, IAdvancementPredicate> map2) {
        this.field_226990_b_ = intBound;
        this.field_226991_c_ = gameType;
        this.field_226992_d_ = map;
        this.field_226993_e_ = object2BooleanMap;
        this.field_226994_f_ = map2;
    }

    public boolean func_226998_a_(Entity entity) {
        if (this == field_226989_a_) {
            return true;
        }
        if (!(entity instanceof ServerPlayerEntity)) {
            return false;
        }
        ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)entity;
        if (!this.field_226990_b_.func_211339_d(serverPlayerEntity.field_71068_ca)) {
            return false;
        }
        if (this.field_226991_c_ != GameType.NOT_SET && this.field_226991_c_ != serverPlayerEntity.field_71134_c.func_73081_b()) {
            return false;
        }
        ServerStatisticsManager \u26032 = serverPlayerEntity.func_147099_x();
        for (Map.Entry<Stat<?>, MinMaxBounds.IntBound> entry : this.field_226992_d_.entrySet()) {
            int n = \u26032.func_77444_a(entry.getKey());
            if (entry.getValue().func_211339_d(n)) continue;
            return false;
        }
        ServerRecipeBook \u26033 = serverPlayerEntity.func_192037_E();
        for (Object2BooleanMap.Entry entry : this.field_226993_e_.object2BooleanEntrySet()) {
            if (\u26033.func_226144_b_((ResourceLocation)entry.getKey()) == entry.getBooleanValue()) continue;
            return false;
        }
        if (!this.field_226994_f_.isEmpty()) {
            PlayerAdvancements playerAdvancements = serverPlayerEntity.func_192039_O();
            AdvancementManager \u26035 = serverPlayerEntity.func_184102_h().func_191949_aK();
            for (Map.Entry<ResourceLocation, IAdvancementPredicate> entry : this.field_226994_f_.entrySet()) {
                Advancement advancement = \u26035.func_192778_a(entry.getKey());
                if (advancement != null && entry.getValue().test(playerAdvancements.func_192747_a(advancement))) continue;
                return false;
            }
        }
        return true;
    }

    public static PlayerPredicate func_227000_a_(@Nullable JsonElement jsonElement) {
        StatType<?> \u26037;
        Object object;
        JsonElement \u260392;
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_226989_a_;
        }
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "player");
        MinMaxBounds.IntBound \u26032 = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("level"));
        String \u26033 = JSONUtils.func_151219_a(jsonObject, "gamemode", "");
        GameType \u26034 = GameType.func_185328_a(\u26033, GameType.NOT_SET);
        HashMap \u26035 = Maps.newHashMap();
        JsonArray \u26036 = JSONUtils.func_151213_a(jsonObject, "stats", null);
        if (\u26036 != null) {
            for (JsonElement \u260392 : \u26036) {
                object = JSONUtils.func_151210_l(\u260392, "stats entry");
                object2 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, "type"));
                \u26037 = Registry.field_212634_w.func_82594_a((ResourceLocation)object2);
                if (\u26037 == null) {
                    throw new JsonParseException("Invalid stat type: " + object2);
                }
                ResourceLocation \u26038 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, "stat"));
                object3 = PlayerPredicate.func_226997_a_(\u26037, \u26038);
                \u2603 = MinMaxBounds.IntBound.func_211344_a(object.get("value"));
                \u26035.put(object3, \u2603);
            }
        }
        Object2BooleanOpenHashMap object2BooleanOpenHashMap = new Object2BooleanOpenHashMap();
        \u260392 = JSONUtils.func_151218_a(jsonObject, "recipes", new JsonObject());
        for (Object object2 : \u260392.entrySet()) {
            \u26037 = new ResourceLocation((String)object2.getKey());
            boolean bl = JSONUtils.func_151216_b((JsonElement)object2.getValue(), "recipe present");
            object2BooleanOpenHashMap.put((Object)\u26037, bl);
        }
        object = Maps.newHashMap();
        object2 = JSONUtils.func_151218_a(jsonObject, "advancements", new JsonObject());
        for (Map.Entry entry : object2.entrySet()) {
            Object object3 = new ResourceLocation((String)entry.getKey());
            \u2603 = PlayerPredicate.func_227004_b_((JsonElement)entry.getValue());
            object.put(object3, \u2603);
        }
        return new PlayerPredicate(\u26032, \u26034, \u26035, (Object2BooleanMap<ResourceLocation>)object2BooleanOpenHashMap, (Map<ResourceLocation, IAdvancementPredicate>)object);
    }

    private static <T> Stat<T> func_226997_a_(StatType<T> statType, ResourceLocation resourceLocation) {
        Registry<T> registry = statType.func_199080_a();
        T \u26032 = registry.func_82594_a(resourceLocation);
        if (\u26032 == null) {
            throw new JsonParseException("Unknown object " + resourceLocation + " for stat type " + Registry.field_212634_w.func_177774_c(statType));
        }
        return statType.func_199076_b(\u26032);
    }

    private static <T> ResourceLocation func_226996_a_(Stat<T> stat) {
        return stat.func_197921_a().func_199080_a().func_177774_c(stat.func_197920_b());
    }

    public JsonElement func_226995_a_() {
        JsonArray jsonArray;
        if (this == field_226989_a_) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("level", this.field_226990_b_.func_200321_c());
        if (this.field_226991_c_ != GameType.NOT_SET) {
            jsonObject.addProperty("gamemode", this.field_226991_c_.func_77149_b());
        }
        if (!this.field_226992_d_.isEmpty()) {
            jsonArray = new JsonArray();
            this.field_226992_d_.forEach((stat, intBound) -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("type", Registry.field_212634_w.func_177774_c(stat.func_197921_a()).toString());
                jsonObject.addProperty("stat", PlayerPredicate.func_226996_a_(stat).toString());
                jsonObject.add("value", intBound.func_200321_c());
                jsonArray.add((JsonElement)jsonObject);
            });
            jsonObject.add("stats", (JsonElement)jsonArray);
        }
        if (!this.field_226993_e_.isEmpty()) {
            jsonArray = new JsonObject();
            this.field_226993_e_.forEach((arg_0, arg_1) -> PlayerPredicate.func_227002_a_((JsonObject)jsonArray, arg_0, arg_1));
            jsonObject.add("recipes", (JsonElement)jsonArray);
        }
        if (!this.field_226994_f_.isEmpty()) {
            jsonArray = new JsonObject();
            this.field_226994_f_.forEach((arg_0, arg_1) -> PlayerPredicate.func_227001_a_((JsonObject)jsonArray, arg_0, arg_1));
            jsonObject.add("advancements", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    private static /* synthetic */ void func_227001_a_(JsonObject jsonObject, ResourceLocation resourceLocation, IAdvancementPredicate iAdvancementPredicate) {
        jsonObject.add(resourceLocation.toString(), iAdvancementPredicate.func_225544_a_());
    }

    private static /* synthetic */ void func_227002_a_(JsonObject jsonObject, ResourceLocation resourceLocation, Boolean bl) {
        jsonObject.addProperty(resourceLocation.toString(), bl);
    }

    private static /* synthetic */ void func_227003_a_(Object2BooleanMap object2BooleanMap, Map.Entry entry) {
        boolean bl = JSONUtils.func_151216_b((JsonElement)entry.getValue(), "criterion test");
        object2BooleanMap.put(entry.getKey(), bl);
    }

    public static class Default {
        private MinMaxBounds.IntBound field_227007_a_ = MinMaxBounds.IntBound.field_211347_e;
        private GameType field_227008_b_ = GameType.NOT_SET;
        private final Map<Stat<?>, MinMaxBounds.IntBound> field_227009_c_ = Maps.newHashMap();
        private final Object2BooleanMap<ResourceLocation> field_227010_d_ = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, IAdvancementPredicate> field_227011_e_ = Maps.newHashMap();

        public PlayerPredicate func_227012_b_() {
            return new PlayerPredicate(this.field_227007_a_, this.field_227008_b_, this.field_227009_c_, this.field_227010_d_, this.field_227011_e_);
        }
    }

    static class CriteriaPredicate
    implements IAdvancementPredicate {
        private final Object2BooleanMap<String> field_227005_a_;

        public CriteriaPredicate(Object2BooleanMap<String> object2BooleanMap) {
            this.field_227005_a_ = object2BooleanMap;
        }

        @Override
        public JsonElement func_225544_a_() {
            JsonObject jsonObject = new JsonObject();
            this.field_227005_a_.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).addProperty(arg_0, arg_1));
            return jsonObject;
        }

        @Override
        public boolean test(AdvancementProgress advancementProgress) {
            for (Object2BooleanMap.Entry entry : this.field_227005_a_.object2BooleanEntrySet()) {
                CriterionProgress criterionProgress = advancementProgress.func_192106_c((String)entry.getKey());
                if (criterionProgress != null && criterionProgress.func_192151_a() == entry.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static class CompletedAdvancementPredicate
    implements IAdvancementPredicate {
        private final boolean field_227006_a_;

        public CompletedAdvancementPredicate(boolean bl) {
            this.field_227006_a_ = bl;
        }

        @Override
        public JsonElement func_225544_a_() {
            return new JsonPrimitive(Boolean.valueOf(this.field_227006_a_));
        }

        @Override
        public boolean test(AdvancementProgress advancementProgress) {
            return advancementProgress.func_192105_a() == this.field_227006_a_;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static interface IAdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public JsonElement func_225544_a_();
    }
}

