/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.ProxiedItemStackHandler;
import vazkii.quark.base.module.Module;
import vazkii.quark.oddities.client.model.BackpackModel;
import vazkii.quark.oddities.container.BackpackContainer;
import vazkii.quark.oddities.module.BackpackModule;

public class BackpackItem
extends DyeableArmorItem
implements IItemColorProvider,
INamedContainerProvider {
    private static final String WORN_TEXTURE = "quark:textures/misc/backpack_worn.png";
    private static final String WORN_OVERLAY_TEXTURE = "quark:textures/misc/backpack_worn_overlay.png";
    private final Module module;
    @OnlyIn(value=Dist.CLIENT)
    private BipedModel model;

    public BackpackItem(Module module) {
        super((IArmorMaterial)ArmorMaterial.LEATHER, EquipmentSlotType.CHEST, new Item.Properties().func_200917_a(1).func_200918_c(0).func_200916_a(ItemGroup.field_78040_i).func_208103_a(Rarity.RARE));
        RegistryHelper.registerItem((Item)this, (String)"backpack");
        this.module = module;
        this.func_185043_a(new ResourceLocation("has_items"), (stack, world, entity) -> !BackpackModule.superOpMode && BackpackItem.doesBackpackHaveItems(stack) ? 1.0f : 0.0f);
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        LazyOptional handlerOpt = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!handlerOpt.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)handlerOpt.orElse(null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean hasItems = !BackpackModule.superOpMode && BackpackItem.doesBackpackHaveItems(stack);
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        boolean isCursed = enchants.containsKey(Enchantments.field_190941_k);
        boolean changedEnchants = false;
        if (hasItems) {
            if (BackpackModule.isEntityWearingBackpack(entityIn, stack)) {
                if (!isCursed) {
                    enchants.put(Enchantments.field_190941_k, 1);
                    changedEnchants = true;
                }
            } else {
                ItemStack copy = stack.func_77946_l();
                stack.func_190920_e(0);
                entityIn.func_70099_a(copy, 0.0f);
            }
        } else if (isCursed) {
            enchants.remove(Enchantments.field_190941_k);
            changedEnchants = true;
        }
        if (changedEnchants) {
            EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)stack);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (BackpackModule.superOpMode || entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        if (!ItemNBTHelper.detectNBT((ItemStack)stack)) {
            return false;
        }
        LazyOptional handlerOpt = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!handlerOpt.isPresent()) {
            return false;
        }
        IItemHandler handler = (IItemHandler)handlerOpt.orElse(null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack copy = stackAt.func_77946_l();
            InventoryHelper.func_180173_a((World)entityItem.field_70170_p, (double)entityItem.func_226277_ct_(), (double)entityItem.func_226278_cu_(), (double)entityItem.func_226281_cx_(), (ItemStack)copy);
        }
        CompoundNBT comp = ItemNBTHelper.getNBT((ItemStack)stack);
        comp.func_82580_o("Inventory");
        if (comp.func_186856_d() == 0) {
            stack.func_77982_d(null);
        }
        return false;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT oldCapNbt) {
        ProxiedItemStackHandler handler = new ProxiedItemStackHandler(stack, 27);
        if (oldCapNbt != null && oldCapNbt.func_74764_b("Parent")) {
            CompoundNBT itemData = oldCapNbt.func_74775_l("Parent");
            ItemStackHandler stacks = new ItemStackHandler();
            stacks.deserializeNBT(itemData);
            for (int i = 0; i < stacks.getSlots(); ++i) {
                handler.setStackInSlot(i, stacks.getStackInSlot(i));
            }
            oldCapNbt.func_82580_o("Parent");
        }
        return handler;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return HashMultimap.create();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return type != null && type.equals("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        if (this.model == null) {
            this.model = new BackpackModel();
        }
        return this.model;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_150895_a(group, items);
        }
    }

    public boolean isEnabled() {
        return this.module != null && this.module.enabled;
    }

    public IItemColor getItemColor() {
        return (stack, i) -> i > 0 ? -1 : ((DyeableArmorItem)stack.func_77973_b()).func_200886_f(stack);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new BackpackContainer(id, player);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
    }
}

