/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import owmii.lib.block.IBlock;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Stack;

public abstract class AbstractBlock<E extends IVariant>
extends Block
implements IBlock<E> {
    public static final VoxelShape SEMI_FULL_SHAPE = AbstractBlock.func_208617_a((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)15.99, (double)15.99);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    protected final E variant;

    public AbstractBlock(Block.Properties properties) {
        this(properties, IVariant.getEmpty());
    }

    public AbstractBlock(Block.Properties properties, E variant) {
        super(properties);
        this.variant = variant;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.semiFullShape() ? SEMI_FULL_SHAPE : super.func_220053_a(state, worldIn, pos, context);
    }

    protected boolean semiFullShape() {
        return false;
    }

    protected void setDefaultState() {
        this.setStateProps(state -> {});
    }

    protected void setStateProps(Consumer<BlockState> consumer) {
        BlockState state = (BlockState)this.field_176227_L.func_177621_b();
        if (this instanceof IWaterLoggable) {
            state = (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (!this.getFacing().equals((Object)Facing.NORMAL)) {
            state = (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH);
        }
        if (this.hasLitProp()) {
            state = (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        consumer.accept(state);
        this.func_180632_j(state);
    }

    public boolean func_220074_n(BlockState state) {
        return !this.func_200124_e(state);
    }

    @Override
    public E getVariant() {
        return this.variant;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onAdded(world, state, oldState, isMoving);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onRemoved(world, state, newState, isMoving);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).neighborChanged(world, state, pos, block, fromPos, isMoving);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, final BlockRayTraceResult result) {
        INamedContainerProvider provider;
        Container container;
        final TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase && (container = (provider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new ItemStack((IItemProvider)AbstractBlock.this).func_200301_q();
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return AbstractBlock.this.getContainer(i, playerInventory, (TileBase)tile, result);
            }
        }).createMenu(0, player.field_71071_by, player)) != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buffer -> {
                    buffer.func_179255_a(pos);
                    this.additionalGuiData((PacketBuffer)buffer, state, world, pos, player, hand, result);
                });
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    @Nullable
    public <T extends TileBase> ContainerBase getContainer(int id, PlayerInventory inventory, TileBase te, BlockRayTraceResult result) {
        return null;
    }

    protected void additionalGuiData(PacketBuffer buffer, BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onPlaced(world, state, placer, stack);
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileBase) {
            TileBase tile = (TileBase)te;
            ItemStack stack1 = new ItemStack((IItemProvider)this);
            CompoundNBT tag = Stack.getTagOrEmpty(stack1);
            CompoundNBT storable = tile.writeStorable(new CompoundNBT());
            if (!storable.isEmpty() && tile.isNBTStorable()) {
                tag.func_218657_a("lollipopTileStorableNBT", (INBT)storable);
                stack1.func_77982_d(tag);
            }
            if (tile.hasCustomName()) {
                stack1.func_200302_a(tile.getCustomName());
            }
            AbstractBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack1);
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
            player.func_71020_j(0.005f);
        } else {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (this instanceof IWaterLoggable && ((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (!state.func_196955_c((IWorldReader)world, currentPos)) {
            TileEntity tileEntity = world.func_175625_s(currentPos);
            if (!world.func_201670_d() && tileEntity instanceof TileBase) {
                TileBase tile = (TileBase)tileEntity;
                ItemStack stack = new ItemStack((IItemProvider)this);
                CompoundNBT tag = Stack.getTagOrEmpty(stack);
                CompoundNBT storable = tile.writeStorable(new CompoundNBT());
                if (!storable.isEmpty() && tile.isNBTStorable()) {
                    tag.func_218657_a("lollipopTileStorableNBT", (INBT)storable);
                    stack.func_77982_d(tag);
                }
                if (tile.hasCustomName()) {
                    stack.func_200302_a(tile.getCustomName());
                }
                AbstractBlock.func_180635_a((World)((World)world), (BlockPos)currentPos, (ItemStack)stack);
                world.func_175655_b(currentPos, false);
            }
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (te instanceof TileBase) {
            TileBase tile = (TileBase)te;
            CompoundNBT tag = Stack.getTagOrEmpty(stack);
            CompoundNBT nbt = tile.writeStorable(new CompoundNBT());
            if (!nbt.isEmpty()) {
                tag.func_218657_a("lollipopTileStorableNBT", (INBT)nbt);
                stack.func_77982_d(tag);
            }
            if (tile.hasCustomName()) {
                stack.func_200302_a(tile.getCustomName());
            }
        }
        return stack;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.func_204507_t(state).func_206888_e() || super.func_200123_i(state, reader, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            state = !this.isPlacerFacing() ? this.facing(context, false) : (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
        } else if (this.getFacing().equals((Object)Facing.ALL)) {
            state = !this.isPlacerFacing() ? this.facing(context, true) : (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d().func_176734_d());
        }
        if (state != null && this instanceof IWaterLoggable) {
            IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
            state = (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return state;
    }

    @Nullable
    private BlockState facing(BlockItemUseContext context, boolean b) {
        Direction[] directions;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : directions = context.func_196009_e()) {
            Direction direction1;
            if (!b && !direction.func_176740_k().func_176722_c() || !(blockstate = (BlockState)blockstate.func_206870_a((IProperty)FACING, (Comparable)(direction1 = b ? direction : direction.func_176734_d()))).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        if (!this.getFacing().equals((Object)Facing.NORMAL)) {
            for (Rotation rotation : Rotation.values()) {
                if (rotation.equals((Object)Rotation.NONE) || !this.func_196260_a(super.rotate(state, world, pos, rotation), (IWorldReader)world, pos)) continue;
                return super.rotate(state, world, pos, rotation);
            }
        }
        return state;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
        }
        return super.func_185499_a(state, rot);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
        }
        return super.func_185471_a(state, mirror);
    }

    protected boolean isPlacerFacing() {
        return false;
    }

    protected Facing getFacing() {
        return Facing.NORMAL;
    }

    protected boolean hasLitProp() {
        return false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return this instanceof IWaterLoggable && (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null && tileEntity.func_145842_c(id, param);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            builder.func_206894_a(new IProperty[]{FACING});
        }
        if (this instanceof IWaterLoggable) {
            builder.func_206894_a(new IProperty[]{WATERLOGGED});
        }
        if (this.hasLitProp()) {
            builder.func_206894_a(new IProperty[]{LIT});
        }
    }

    protected static enum Facing {
        HORIZONTAL,
        ALL,
        NORMAL;

    }
}

