/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.blocks.AriadneCoalBlock;
import wile.engineerstools.items.AriadneCoalItem;
import wile.engineerstools.items.AutoStimPackItem;
import wile.engineerstools.items.CrushingHammerItem;
import wile.engineerstools.items.DivingCapsuleItem;
import wile.engineerstools.items.ModBlockItem;
import wile.engineerstools.items.MusliBarItem;
import wile.engineerstools.items.MusliBarPressItem;
import wile.engineerstools.items.RediaToolItem;
import wile.engineerstools.items.SleepingBagItem;
import wile.engineerstools.libmc.detail.Auxiliaries;

public class ModConfig {
    private static final Logger LOGGER = ModEngineersTools.LOGGER;
    private static final String MODID = "engineerstools";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    private static final ArrayList<String> includes_;
    private static final ArrayList<String> excludes_;
    private static final CompoundNBT server_config_;
    public static boolean with_experimental;

    public static void onLoad(net.minecraftforge.fml.config.ModConfig config) {
        try {
            ModConfig.apply();
            LOGGER.info("Loaded config file {}", (Object)config.getFileName());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to apply config file data {}", (Object)config.getFileName());
        }
    }

    public static void onFileChange(net.minecraftforge.fml.config.ModConfig config) {
        LOGGER.info("Config file changed {}", (Object)config.getFileName());
    }

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block, false);
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        return ModConfig.isOptedOut(item, false);
    }

    public static final boolean isOptedOut(@Nullable Block block, boolean with_log_details) {
        if (block == null) {
            return true;
        }
        if (COMMON == null) {
            return false;
        }
        try {
            if (!with_experimental && block instanceof Auxiliaries.IExperimentalFeature) {
                return true;
            }
            String rn = block.getRegistryName().func_110623_a();
            try {
                for (String e : includes_) {
                    if (!rn.matches(e)) continue;
                    if (with_log_details) {
                        LOGGER.info("Optout force include: " + rn);
                    }
                    return false;
                }
                for (String e : excludes_) {
                    if (!rn.matches(e)) continue;
                    if (with_log_details) {
                        LOGGER.info("Optout force exclude: " + rn);
                    }
                    return true;
                }
            }
            catch (Throwable ex) {
                LOGGER.error("optout include pattern failed, disabling.");
                includes_.clear();
                excludes_.clear();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
        }
        return false;
    }

    public static final boolean isOptedOut(@Nullable Item item, boolean with_log_details) {
        if (item == null) {
            return true;
        }
        if (item instanceof ModBlockItem && ((ModBlockItem)item).func_179223_d() instanceof AriadneCoalBlock) {
            return true;
        }
        if (COMMON == null) {
            return false;
        }
        if (((Boolean)ModConfig.COMMON.without_crushing_hammer.get()).booleanValue() && item instanceof CrushingHammerItem) {
            return true;
        }
        if (((Boolean)ModConfig.COMMON.without_redia_tool.get()).booleanValue() && item instanceof RediaToolItem) {
            return true;
        }
        if (((Boolean)ModConfig.COMMON.without_ariadne_coal.get()).booleanValue() && item instanceof AriadneCoalItem) {
            return true;
        }
        if (((Boolean)ModConfig.COMMON.without_diving_capsule.get()).booleanValue() && item instanceof DivingCapsuleItem) {
            return true;
        }
        if (((Boolean)ModConfig.COMMON.without_stimpack.get()).booleanValue() && item instanceof AutoStimPackItem) {
            return true;
        }
        if (((Boolean)ModConfig.COMMON.without_sleeping_bag.get()).booleanValue() && item instanceof SleepingBagItem) {
            return true;
        }
        if (((Boolean)ModConfig.COMMON.without_musli_bar.get()).booleanValue() && (item instanceof MusliBarItem || item instanceof MusliBarPressItem)) {
            return true;
        }
        try {
            String rn = item.getRegistryName().func_110623_a();
            try {
                for (String e : includes_) {
                    if (!rn.matches(e)) continue;
                    if (with_log_details) {
                        LOGGER.info("Optout force include: " + rn);
                    }
                    return false;
                }
                for (String e : excludes_) {
                    if (!rn.matches(e)) continue;
                    if (with_log_details) {
                        LOGGER.info("Optout force exclude: " + rn);
                    }
                    return true;
                }
            }
            catch (Throwable ex) {
                LOGGER.error("optout include pattern failed, disabling.");
                includes_.clear();
                excludes_.clear();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
        }
        return false;
    }

    public static final CompoundNBT getServerConfig() {
        return server_config_;
    }

    public static final void apply() {
        int i;
        with_experimental = (Boolean)ModConfig.COMMON.with_experimental.get();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("engineerstools:", "").replaceAll("[^*_,a-z0-9]", "");
        if (ModConfig.COMMON.pattern_includes.get() != inc) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        if (!inc.isEmpty()) {
            LOGGER.info("Pattern includes: '" + inc + "'");
        }
        String[] incl = inc.split(",");
        includes_.clear();
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes_.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("engineerstools:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!exc.isEmpty()) {
            LOGGER.info("Pattern excludes: '" + exc + "'");
        }
        String[] excl = exc.split(",");
        excludes_.clear();
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes_.add(excl[i]);
        }
        if (((String)ModConfig.COMMON.redia_tool_efficiency_curve.get()).equals("10,60,90,100,120,140,170,200,220,230")) {
            ModConfig.COMMON.redia_tool_efficiency_curve.set((Object)"0,1,1,2,2,3,3,3,3,4");
        }
        RediaToolItem.on_config(false, false, false, (Integer)ModConfig.COMMON.redia_tool_durability.get(), (String)ModConfig.COMMON.redia_tool_efficiency_curve.get(), (String)ModConfig.COMMON.redia_tool_furtune_curve.get(), (Integer)ModConfig.COMMON.redia_tool_initial_durability_percent.get(), (Integer)ModConfig.COMMON.redia_tool_attack_cooldown_ms.get(), (Boolean)ModConfig.COMMON.without_safe_attacking.get());
        AutoStimPackItem.on_config(2, 3, 3);
        DivingCapsuleItem.on_config(10, 3, 7);
        MusliBarItem.on_config(6, 1.2);
        MusliBarPressItem.on_config(512, 128, 1, 8);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        Pair client_ = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)client_.getRight();
        CLIENT = (ClientConfig)client_.getLeft();
        includes_ = new ArrayList();
        excludes_ = new ArrayList();
        server_config_ = new CompoundNBT();
        with_experimental = false;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue without_crushing_hammer;
        public final ForgeConfigSpec.BooleanValue without_redia_tool;
        public final ForgeConfigSpec.BooleanValue without_stimpack;
        public final ForgeConfigSpec.BooleanValue without_diving_capsule;
        public final ForgeConfigSpec.BooleanValue without_ariadne_coal;
        public final ForgeConfigSpec.BooleanValue without_sleeping_bag;
        public final ForgeConfigSpec.BooleanValue without_musli_bar;
        public final ForgeConfigSpec.IntValue redia_tool_durability;
        public final ForgeConfigSpec.IntValue redia_tool_initial_durability_percent;
        public final ForgeConfigSpec.ConfigValue<String> redia_tool_efficiency_curve;
        public final ForgeConfigSpec.ConfigValue<String> redia_tool_furtune_curve;
        public final ForgeConfigSpec.BooleanValue without_safe_attacking;
        public final ForgeConfigSpec.IntValue redia_tool_attack_cooldown_ms;
        public final ForgeConfigSpec.BooleanValue with_experimental;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side, but are also configurable in single player.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("engineerstools.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("engineerstools.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            this.without_crushing_hammer = builder.translation("engineerstools.config.without_crushing_hammer").comment("Completely disable the crushing hammer.").define("without_crushing_hammer", false);
            this.without_redia_tool = builder.translation("engineerstools.config.without_redia_tool").comment("Completely disable the REDIA tool.").define("without_redia_tool", false);
            this.without_stimpack = builder.translation("engineerstools.config.without_stimpack").comment("Completely disable the Auto Stim Pack.").define("without_stimpack", false);
            this.without_diving_capsule = builder.translation("engineerstools.config.without_diving_capsule").comment("Completely disable the Diving Air Capsule.").define("without_diving_capsule", false);
            this.without_ariadne_coal = builder.translation("engineerstools.config.without_ariadne_coal").comment("Completely disable the Ariadne Coal.").define("without_ariadne_coal", false);
            this.without_sleeping_bag = builder.translation("engineerstools.config.without_sleeping_bag").comment("Completely disable the Sleeping Bag.").define("without_sleeping_bag", false);
            this.without_musli_bar = builder.translation("engineerstools.config.without_musli_bar").comment("Completely disable the Muslee Bar and Muslee Bar Press.").define("without_musli_bar", false);
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("engineerstools.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            builder.pop();
            builder.comment("Settings to tweak the performance, or use cases normally no change should be required here.").push("tweaks");
            this.redia_tool_durability = builder.translation("engineerstools.config.redia_tool_durability").comment("Durability (maximum item damage) of the REDIA tool.").defineInRange("redia_tool_durability", 3000, 750, 4000);
            this.redia_tool_initial_durability_percent = builder.translation("engineerstools.config.redia_tool_initial_durability_percent").comment("Durability of the REDIA tool in percent, which the tool has when it is crafted. Allows to tune initial repairing investments for getting efficiency and furtune.").defineInRange("redia_tool_initial_durability_percent", 100, 50, 100);
            this.redia_tool_efficiency_curve = builder.translation("engineerstools.config.redia_tool_efficiency_curve").comment("Defines the efficiency scaling depending on the durability. Ten values have to given as integer numbers, (between 0 and 4), and the curve must be rising left-to-right. 0 corresponds to vanilla diamond tools. The first number specifies the efficiency between 0% and 10% durability, second 10% to 20%, last 90% to 100%.").define("redia_tool_efficiency_curve", (Object)"0,1,1,2,2,3,3,3,3,4");
            this.redia_tool_furtune_curve = builder.translation("engineerstools.config.redia_tool_furtune_curve").comment("Defines the fortune depending on the durability. Ten values have to given as integer numbers, (between 0 and 3), and the curve must be rising left-to-right. The first number specifies the furtune between 0% and 10% durability, second 10% to 20%, last 90% to 100%.").define("redia_tool_furtune_curve", (Object)"0,0,0,0,1,1,1,1,2,3");
            this.without_safe_attacking = builder.translation("engineerstools.config.without_safe_attacking").comment("Disable the REDIA tool feature to prevent accidentally hitting own pets, villagers, or bloody zombie pigmen.").define("without_safe_attacking", false);
            this.redia_tool_attack_cooldown_ms = builder.translation("engineerstools.config.redia_tool_attack_cooldown_ms").comment("If safe attacking is enabled, this defines in milliseconds how long you cannot accidentally hit passive non-agressive mobs when breaking blocks. The time does not affect preventing to hit villagers, own pets, or zombie pigmen.").defineInRange("redia_tool_attack_cooldown_ms", 0, 10, 2500);
            builder.pop();
        }
    }

    public static class ServerConfig {
        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on clients.").push("server");
            builder.pop();
        }
    }

    public static class ClientConfig {
        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on servers.").push("client");
            builder.pop();
        }
    }
}

